#include "DecObserver.h"
#include "DecEvent.h"
#include "ObserverIterator.h"
#include "ObserverObsEventIterator.h"
#include "DecentralizedEventEditor.h"
#include "DesIterator.h"
#include "DesIntegrityAlgo.h"

namespace DESpot
{
    DecObserver::DecObserver(const std::wstring& name):
            m_name(name),
            m_isModified(true),
            m_isEventModified(false)
    {
    }

//_________________________________________________________________________________

    DecObserver::~DecObserver(void)
    {
    }
//____________________________________________________________________________________

    std::wstring DecObserver::getName() const
    {
        return m_name;
    }

//____________________________________________________________________________________

    void DecObserver::setName(const std::wstring& name)
    {
        if(name.empty())
            throw EX("Cannot give a decentralized supervisor an empty name")

        m_name = name;
    }

//____________________________________________________________________________________

    void DecObserver::setLoadInProgress(bool loadInProgress)
    {
        m_bLoadInProgress = loadInProgress;
    }

//______________________________________________________________________________________

    void DecObserver::setModified(bool isModified)
    {
        m_isModified = isModified;
    }

//____________________________________________________________________________________

    bool DecObserver::isModified() const
    {
        return m_isModified;
    }

//_______________________________________________________________________________________

    void DecObserver::save()
    {
        setModified(false);
    }
//______________________________________________________________________________________________

    bool DecObserver::transExits(const std::wstring& name)
    {
        ObsvObsEventMapIt obsEventMapIt = m_ObsvObsEventMap.find(name);
        if(obsEventMapIt != m_ObsvObsEventMap.end())
        {
            return true;
        }
        return false;
    }

//______________________________________________________________________________________________

    DecObserver::ObserverCtrlEventIteratorPtr DecObserver::createObserverCtrlEventIterator() const
    {
        const ObserverCtrlEventIterator* pObsvCtrlEventIt = new DESpot::ObserverCtrlEventIterator(m_ObsvCtrlEventMap);
        return ObserverCtrlEventIteratorPtr(pObsvCtrlEventIt);
    }

//______________________________________________________________________________________________

    const DecEvent& DecObserver::addCtrlEvent(const std::wstring &name)
    {
        DecEvent* ObsvCtrlEvent = new DecEvent(name);
        try
        {
            addObsvCtrlEvent(ObsvCtrlEvent);

        }
        catch(...)
        {
            delete ObsvCtrlEvent;
            throw;
        }
        return *ObsvCtrlEvent;
    }

//______________________________________________________________________________________________

    void DecObserver::addObsvCtrlEvent(DecEvent *ObsvCtrlEvent)
    {
        if(ObsvCtrlEvent == null)
            throw EX("Cannot add null event to the pool")

        // find event with the same name in the event list of that Observer
        if(m_ObsvCtrlEventMap.find(ObsvCtrlEvent->getName()) != m_ObsvCtrlEventMap.end())
            throw EX ("Event name already exists. Choose another name")

        m_ObsvCtrlEventMap[ObsvCtrlEvent->getName()] = ObsvCtrlEvent;
    }

//_______________________________________________________________________________________

    DecObserver::ObserverObsEventIteratorPtr DecObserver::createObserverObsEventIterator() const
    {
        const ObserverObsEventIterator* pObsvObsEventIt = new DESpot::ObserverObsEventIterator(m_ObsvObsEventMap);
        return ObserverObsEventIteratorPtr(pObsvObsEventIt);
    }

//______________________________________________________________________________________________

    const DecEvent& DecObserver::addObsEvent(const std::wstring &name)
    {
        DecEvent* ObsvObsEvent = new DecEvent(name);
        try
        {
            addObsvObsEvent(ObsvObsEvent);
        }
        catch(...)
        {
            delete ObsvObsEvent;
            throw;
        }
        return *ObsvObsEvent;
    }

//______________________________________________________________________________________________

    void DecObserver::addObsvObsEvent(DecEvent* ObsvObsEvent)
    {
        if(ObsvObsEvent == null)
            throw EX("Cannot add null event to the pool")

        // find event with the same name in the event list of that Observer
        if(m_ObsvObsEventMap.find(ObsvObsEvent->getName()) != m_ObsvObsEventMap.end())
            throw EX ("Event name already exists. Choose another name")

        m_ObsvObsEventMap[ObsvObsEvent->getName()] = ObsvObsEvent;
    }

//_________________________________________________________________________________________________________________

    void DecObserver::deleteObsEvent(const std::wstring &name)
    {
        ObsvObsEventMapIt obsEventMapIt = m_ObsvObsEventMap.find(name);
        if(obsEventMapIt == m_ObsvObsEventMap.end())
        {
            throw EX("There is no event with the given name.");
        }

        DecEvent* decEvent = obsEventMapIt->second;
        m_ObsvObsEventMap.erase(obsEventMapIt);

        delete decEvent;
        decEvent = null;
    }

//______________________________________________________________________________________________

    void DecObserver::deleteCtrlEvent(const std::wstring &name)
    {
        ObsvCtrlEventMapIt ctrlEventMapIt = m_ObsvCtrlEventMap.find(name);
        if(ctrlEventMapIt == m_ObsvCtrlEventMap.end())
        {
            throw EX("There is no event with the given name.");
        }

        DecEvent* decEvent = ctrlEventMapIt->second;
        m_ObsvCtrlEventMap.erase(ctrlEventMapIt);

        delete decEvent;
        decEvent = null;
    }

//______________________________________________________________________________________________

    bool DecObserver::findObsvCtrlEvent(const std::wstring &ObsvCtrlEventName) const
    {
        const ObserverCtrlEventIterator* pObsvCtrlEventIt = new DESpot::ObserverCtrlEventIterator(m_ObsvCtrlEventMap);

        for(pObsvCtrlEventIt->first(); pObsvCtrlEventIt->isDone() == false; pObsvCtrlEventIt->next())
        {
            const DecEvent& crtEvent = pObsvCtrlEventIt->currentItem();
            if(crtEvent.getName() == ObsvCtrlEventName)
            {
                return true;
            }
        }
        return false;
    }

//______________________________________________________________________________________________

    bool DecObserver::findObsvObsEvent(const std::wstring &ObsvObsEventName) const
    {
        const ObserverObsEventIterator* pObsvObsEventIt = new DESpot::ObserverObsEventIterator(m_ObsvObsEventMap);

        for(pObsvObsEventIt->first(); pObsvObsEventIt->isDone() == false; pObsvObsEventIt->next())
        {
            const DecEvent& crtEvent = pObsvObsEventIt->currentItem();
            if(crtEvent.getName() == ObsvObsEventName)
            {
                return true;
            }
        }
        return false;
    }

//______________________________________________________________________________________________

    void DecObserver::clearObsvCtrlEventlist()
    {
        ObsvCtrlEventMapIt itr;
        for(itr = m_ObsvCtrlEventMap.begin(); itr != m_ObsvCtrlEventMap.end(); ++itr)
        {
            m_ObsvCtrlEventMap.erase(itr);
        }
    }

//______________________________________________________________________________________________

    void DecObserver::clearObsvObsEventlist()
    {
        ObsvObsEventMapIt itr;
        for(itr = m_ObsvObsEventMap.begin(); itr != m_ObsvObsEventMap.end(); ++itr)
        {
            m_ObsvObsEventMap.erase(itr);
        }
    }

//______________________________________________________________________________________

    void DecObserver::setEventModified(bool isModified)
    {
        m_isEventModified = isModified;
    }

//____________________________________________________________________________________

    bool DecObserver::isEventModified() const
    {
        return m_isEventModified;
    }

}
