#include <QMessageBox>
#include <QHeaderView>
#include <QtCore>

#include "DecObserver.h"
#include "DecentralizedEventEditorUi.h"
#include "CommonDefinitions.h"
#include "DesProject.h"
#include "ObserverIterator.h"
#include "DecEvent.h"
#include "ProjectEvent.h"

namespace DESpot
{
    DecentralizedEventEditorUi::DecentralizedEventEditorUi(Ui::DecentralizedEventEdUI* pUiContainer, DesProject* project): m_project(project), m_crtObsv(null), m_isModified(false)
    {
		initWidgets(pUiContainer);
		setupConnections();
		setupObserverWidget();
		setupProjCtrlEventWidget();
		setupProjObsEventWidget();
    }

//_____________________________________________________________________________________________________________

    DecentralizedEventEditorUi::~DecentralizedEventEditorUi(void)
    {
    }

//_________________________________________________________________________________________________________

    void DecentralizedEventEditorUi::initWidgets(Ui::DecentralizedEventEdUI *pUiContainer)
    {
		m_AvlObsEventsTreeWidget = pUiContainer->m_AvlObsEventsTreeWidget;
		m_AvlCtrlEventsTreeWidget = pUiContainer->m_AvlCtrlEventsTreeWidget;
		m_SelCtrlEventslistWidget = pUiContainer->m_SelCtrlEventslistWidget;
		m_SelObsEventslistWidget = pUiContainer->m_SelObsEventslistWidget;
		m_ObservernamecomboBox = pUiContainer->m_ObservernamecomboBox;
		m_AddObsEvent = pUiContainer->m_AddObsEvent;
		m_AddCtrlEvent = pUiContainer->m_AddCtrlEvent;
		m_RemoveObsEvent = pUiContainer->m_RemoveObsEvent;
		m_RemoveCtrlEvent = pUiContainer->m_RemoveCtrlEvent;
    }

//_________________________________________________________________________________________

    void DESpot::DecentralizedEventEditorUi::setupConnections()
    {
		connect(m_AddObsEvent, SIGNAL(clicked()), this, SLOT(onAddProjectObsEventsToObserver()));
		connect(m_AddCtrlEvent, SIGNAL(clicked()), this, SLOT(onAddProjectCtrlEventsToObserver()));
		connect(m_RemoveObsEvent, SIGNAL(clicked()), this, SLOT(onRemoveObsEventsFromObserver()));
		connect(m_RemoveCtrlEvent, SIGNAL(clicked()), this, SLOT(onRemoveCtrlEventsFromObserver()));
		connect(m_ObservernamecomboBox, SIGNAL(currentIndexChanged(int)), this, SLOT(onObserverSelected(int)));
    }

//_______________________________________________________________________________________________________________

    void DecentralizedEventEditorUi::setModified(bool isModified)
    {
        m_isModified = isModified;
    }

//____________________________________________________________________________________

    bool DecentralizedEventEditorUi::isModified() const
    {
        return m_isModified;
    }

//____________________________________________________________________________________

    void DecentralizedEventEditorUi::save()
    {
        setModified(false);
    }

//_________________________________________________________________________________________________

    std::wstring DecentralizedEventEditorUi::getObsvName() const
    {
    	return m_observerName;
    }

//_________________________________________________________________________________________________

    void DESpot::DecentralizedEventEditorUi::setupProjCtrlEventWidget()
    {
        m_AvlCtrlEventsTreeWidget->loadCtrlEvents(m_project, m_crtObsv);
    }

//_________________________________________________________________________________________________

    void DecentralizedEventEditorUi::setupProjObsEventWidget()
    {
    	m_AvlObsEventsTreeWidget->loadObsEvents(m_project, m_crtObsv);
    }

//_________________________________________________________________________________________________

    void DESpot::DecentralizedEventEditorUi::onAddProjectObsEventsToObserver()
    {
        try
		{
            QList<QListWidgetItem*> eventList = m_AvlObsEventsTreeWidget->selectedItems();

            if(eventList.size() == 0)
            {
                QMessageBox::critical(m_AvlObsEventsTreeWidget->topLevelWidget(), STR_DESPOT_ERROR, "No event selected. Please select an event to add.");
                return;
            }

            for(int iEvent = 0; iEvent< eventList.size(); iEvent++)
            {
                QString eventName = eventList.at(iEvent)->text();

            	m_AvlObsEventsTreeWidget->takeItem(m_AvlObsEventsTreeWidget->currentRow());
                m_SelObsEventslistWidget->addItem(eventName);
                m_crtObsv->addObsEvent(eventName.toStdWString());
            }
            m_crtObsv->setModified();
		}
    	catch_display_ex_in(m_AvlObsEventsTreeWidget->topLevelWidget());
    }

//_________________________________________________________________________________________________

    void DESpot::DecentralizedEventEditorUi::onAddProjectCtrlEventsToObserver()
    {
        try
        {
            QList<QListWidgetItem*> eventList = m_AvlCtrlEventsTreeWidget->selectedItems();

            if(eventList.size() == 0)
            {
                QMessageBox::critical(m_AvlCtrlEventsTreeWidget->topLevelWidget(), STR_DESPOT_ERROR, "No event selected. Please select an event to add.");
                return;
            }

            for(int iEvent = 0; iEvent< eventList.size(); iEvent++)
            {
                QString eventName = eventList.at(iEvent)->text();

                m_AvlCtrlEventsTreeWidget->takeItem(m_AvlCtrlEventsTreeWidget->currentRow());
                m_SelCtrlEventslistWidget->addItem(eventName);
                m_crtObsv->addCtrlEvent(eventName.toStdWString());
            }
            m_crtObsv->setModified();
		}
        catch_display_ex_in(m_AvlCtrlEventsTreeWidget->topLevelWidget());
    }

//_________________________________________________________________________________________________

    void DESpot::DecentralizedEventEditorUi::onRemoveCtrlEventsFromObserver()
    {
        try
        {
            QList<QListWidgetItem*> Item = m_SelCtrlEventslistWidget->selectedItems();

            if(Item.size() == 0)
            {
                QMessageBox::critical(m_SelCtrlEventslistWidget->topLevelWidget(), STR_DESPOT_ERROR, "No event selected. Please select an event to remove.");
                return;
            }

            for(int i = 0; i < Item.size(); i++)
			{
				QString eventName = Item.at(i)->text();
				m_SelCtrlEventslistWidget->takeItem(m_SelCtrlEventslistWidget->currentRow());
				m_AvlCtrlEventsTreeWidget->addItem(eventName);
                m_crtObsv->deleteCtrlEvent(eventName.toStdWString());
			}
            m_crtObsv->setModified();
        }
        catch_display_ex_in(m_SelCtrlEventslistWidget->parentWidget());
    }

//____________________________________________________________________________________________________________________________

    void DESpot::DecentralizedEventEditorUi::onRemoveObsEventsFromObserver()
    {
        try
        {
            QList<QListWidgetItem*> Item = m_SelObsEventslistWidget->selectedItems();

            if(Item.size() == 0)
            {
                QMessageBox::critical(m_SelObsEventslistWidget->topLevelWidget(), STR_DESPOT_ERROR, "No event selected. Please select an event to remove.");
                return;
            }

            for(int i = 0; i < Item.size(); i++)
			{
				QString eventName = Item.at(i)->text();
				m_SelObsEventslistWidget->takeItem(m_SelObsEventslistWidget->currentRow());
				m_AvlObsEventsTreeWidget->addItem(eventName);
                m_crtObsv->deleteObsEvent(eventName.toStdWString());
			}
            m_crtObsv->setModified();
        }
        catch_display_ex_in(m_SelObsEventslistWidget->parentWidget());
    }

//__________________________________________________________________________________________________________________________

    void DESpot::DecentralizedEventEditorUi::onObserverSelected(int index)
    {
        m_crtObsv = reinterpret_cast<DecObserver*>((m_ObservernamecomboBox->itemData(index)).toULongLong());
        m_SelCtrlEventslistWidget->loadCtrlData(m_crtObsv);
        m_SelObsEventslistWidget->loadObsData(m_crtObsv);
        m_AvlCtrlEventsTreeWidget->loadCtrlEvents(m_project, m_crtObsv);
        m_AvlObsEventsTreeWidget->loadObsEvents(m_project, m_crtObsv);
    }

//______________________________________________________________________________________________
    void DecentralizedEventEditorUi::setupObserverWidget()
    {
        DesProject::ObserverIteratorPtr ObsvIt = m_project->createObserverIterator();

        for(ObsvIt->first(); ObsvIt->notDone(); ObsvIt->next())
        {
            const DecObserver& Obsv = ObsvIt->currentItem();
        	m_ObservernamecomboBox->addItem(QString::fromStdWString(Obsv.getName()), reinterpret_cast<unsigned long long>(&Obsv));
            
            DecObserver& newObsv=const_cast<DecObserver&>(Obsv);
            newObsv.setEventModified(false);
        }
        m_ObservernamecomboBox->setCurrentIndex(0);
    }


}//end of namespace



