/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2015
*/

#pragma once
//#include <iostream>
#include "DefaultFTAlgo.h"
#include "Des.h"
#include "DesFlatProject.h"
#include "FlatDummyProject.h"
#include "MultiCtrlAlgo.h"
#include "FlatProjIntegrityAlgo.h"

namespace DESpot

{
DefaultFTAlgo::DefaultFTAlgo(const DesProject& currentProject, QList<QString>& currentFaultSet): m_currentProject(currentProject),m_faultSet(currentFaultSet),m_isDFTControllable(false)
{
	GFDes = NULL;
	m_flatDummyProject = NULL;
}
//____________________________________________________________________________________________________________________________________	
DefaultFTAlgo::~DefaultFTAlgo()
{
}
//____________________________________________________________________________________________________________________________________
bool DefaultFTAlgo::runAlgo()
{

	// check that excluded fault set is valid
	if (! (m_currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  


	if (! m_faultSet.isEmpty())	
	{
		DefaultFTAlgo::createDummyFlatProject();
		DefaultFTAlgo::constructGF();
		DefaultFTAlgo::addGF();
		return DefaultFTAlgo::verifyFTCtrl();
	}
	else
	{throw EX("There are no excluded fault events. Please run the standard controllability algorithm.");}

	return false;
}
//____________________________________________________________________________________________________________________________________
void DefaultFTAlgo::constructGF()
{
	if (! m_faultSet.empty())
	{
		const std::wstring& name = L"GF";
		GFDes = new Des(name , eRegularDes);
		DesState* newState = new DesState();
		const std::wstring stateName = L"0";
		newState->setName(stateName);
		const DesState& state = GFDes->addState(const_cast<DesState&>(*newState));
		GFDes->changeStateInit(state.getId(),true);
		GFDes->changeStateMarking(state.getId(),true);
		for (int i=0 ; i < m_faultSet.count() ; i++)
		{
			QString eventName = m_faultSet.at(i);
			const DesEvent* event;
			DesProject::DesIteratorPtr DESIt = m_currentProject.createDesIterator();
			for(DESIt->first(); DESIt->isDone() == false; DESIt->next())
			{
				const Des& currentDes = DESIt->currentItem();
				if (currentDes.findEvent(eventName.toStdWString(),event))
				{
					GFDes->addEvent(const_cast<DesEvent&>(*event));
					break;
				}
			}
		}
	}
}
//____________________________________________________________________________________________________________________________________
void DefaultFTAlgo::constructGFTimed()
{
	if (! m_faultSet.empty())
	{
		const std::wstring& name = L"GF" ;
		GFDes = new Des(name , eRegularDes);
		DesState* newState = new DesState();
		const std::wstring stateName = L"0";
		newState->setName(stateName);
		const DesState& state = GFDes->addState(const_cast<DesState&>(*newState));
		GFDes->changeStateInit(state.getId(),true);
		GFDes->changeStateMarking(state.getId(),true);

		DesEvent* tickEvent = new DesEvent();
		const std::wstring& tickName = L"tick" ;
		const std::wstring& aliasName = L"t" ;
		tickEvent->setName(tickName);
		tickEvent->setAlias(aliasName);
		tickEvent->setControllable(true);
		const DesEvent& tickDESEvent = GFDes->addEvent(const_cast<DesEvent&>(*tickEvent));
		GFDes->addSelfTransition(tickDESEvent);


		DesProject::DesIteratorPtr DESIt = m_currentProject.createDesIterator();
		for (int i=0 ; i < m_faultSet.count() ; i++)
		{
			QString eventName = m_faultSet.at(i);
			const DesEvent* event;
			for(DESIt->first(); DESIt->isDone() == false; DESIt->next())
			{
				const Des& currentDes = DESIt->currentItem();
				if (currentDes.findEvent(eventName.toStdWString(),event))
				{GFDes->addEvent(const_cast<DesEvent&>(*event));
				break;}
			}
		}
	}
	else if (m_faultSet.isEmpty())
		{throw EX("There are no excluded fault events. Please run the standard timed controllability algorithm.");}
}
//____________________________________________________________________________________________________________________________________
void DefaultFTAlgo::createDummyFlatProject()
{
	FlatDummyProject* flatDummyProject;
	flatDummyProject = new FlatDummyProject(m_currentProject);
	m_flatDummyProject = flatDummyProject->GetDummyProject(); 
}
//____________________________________________________________________________________________________________________________________
void DefaultFTAlgo::addGF()
{
	m_flatDummyProject->addPlantDes(GFDes); 
}
//____________________________________________________________________________________________________________________________________
bool DefaultFTAlgo::verifyFTCtrl()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		MultiCtrlAlgo ctrlAlgo(m_flatDummyProject->createDesIterator(ePlantDes),m_flatDummyProject->createDesIterator(eSupervisorDes));
		m_isDFTControllable = (m_flatDummyProject->checkControllable(ctrlAlgo));
		return m_isDFTControllable;
	}
	else
	{	
		throw EX("Project Integrity test has failed");
	}

	return m_isDFTControllable;
}
//____________________________________________________________________________________________________________________________________
bool DefaultFTAlgo::isDFTControllable() const
{
	return m_isDFTControllable;
}
//____________________________________________________________________________________________________________________________________
}


