/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include "DesState.h"
#include "TemplateNameParser.h"

namespace DESpot
{
						 
const DesState::Props DesState::cInitFlagMask		= 1; //00000001		
const DesState::Props DesState::cMarkFlagMask		= 2; //00000010
const DesState::Props DesState::cReachSetFlagMask	= 4; //00000100
const DesState::Props DesState::cReachableFlagMask  = 8; //00001000


const DesState::Props DesState::cDefaultStateProps	 = 0; //00000001		

NameValidator DesState::m_nameValidator(new AlphaNumValidator(new WordSepValidator()));
//add by bini
NameValidator DesState::m_nameValidator2(new AlphaNumValidator(new WordSepValidator(new PercentValidator)));


DesState::DesState(void) : m_id(0)
{
	//By default a state is not the initial one, is non-marked and it is not reachable
	setProps(cDefaultStateProps);
}


//_________________________________________________________________________________________________

DesState::DesState(DesState::ID stateId) : m_id(stateId)
{
	//By default a state is not the initial one, is non-marked and it is not reachable
	setProps(cDefaultStateProps);
}

//_________________________________________________________________________________________________

DesState::DesState(DesState::ID stateId, const DesState& otherState) : m_id(stateId)
{
	*this = otherState;
}

//_________________________________________________________________________________________________

DesState::DesState(const DesState& otherState)
{		
	*this = otherState;
}

//_________________________________________________________________________________________________

DesState::~DesState(void)
{
}

//_________________________________________________________________________________________________

DesState& DesState::operator= (const DesState& otherState)
{
	if (this == &otherState)
		return *this; //the same already

	m_name  = otherState.m_name;
	m_alias = otherState.m_alias;
	m_props = otherState.m_props;

	//note that the ID cannot be copied as it is only assigned once at creation time and never changed
	//to obtain an exact copy of the state you have to use the copy constructor and create a copy from the start
	return *this;
}

//_________________________________________________________________________________________________

//reset the fields of the state to their initial values. This makes it possible
//to reuse state as templates
void DesState::reset()
{
	m_name.clear();
	m_alias.clear();
	setProps(cDefaultStateProps);
}
void DesState::resetAlias()
{
	m_alias.clear();
}

		void DesState::setName(const std::wstring& newName,bool isLoading)
		{
			//isLoading=false;	
			m_name = newName;
			return;
			if(isLoading)
			{	
				TemplateNameParser* NameParser=new TemplateNameParser(newName);
				if(NameParser->isTemplateName())
				{
					state_isTemplate=true;
				}
			if(state_isTemplate)
			{
				if (m_nameValidator2.validate(newName))
				{
					m_name = newName;
				}
				else
				{
					std::wstring message = L"Invalid template state name (";
					message += newName;
					message += L"). Use an alpha-numeric string (a-z;A-Z;0-9;.-_;%)";
					throw message;
				}
			}
			else
			{
				if (m_nameValidator.validate(newName))
				{
					m_name = newName;
				}
				else
				{
					std::wstring message = L"Invalid state name (";
					message += newName;
					message += L"). Use an alpha-numeric string (a-z;A-Z;0-9;.-_)";
					throw message;
				}
			}
		}
		}

		void DesState::setAlias(const std::wstring& newAlias,bool isLoading)
		{
			//isLoading=false;
			m_alias = newAlias;
			return;
			if(isLoading)
			{	
				TemplateNameParser* NameParser=new TemplateNameParser(newAlias);
				if(NameParser->isTemplateName())
				{
					state_isTemplate=true;
				}	
			if(isTemplate())
			{
				if (m_nameValidator2.validate(newAlias))
				{
					m_alias = newAlias;
				}
				else
				{
				std::wstring message = L"Invalid template state alias (";
				message += newAlias;
				message += L"). Use an alpha-numeric string (a-z;A-Z;0-9;.-_%)";
				throw message;
				}
			}
			else
			{
				if (m_nameValidator.validate(newAlias))
				{
					m_alias = newAlias;
				}
				else
				{
					std::wstring message = L"Invalid state alias (";
					message += newAlias;
					message += L"). Use an alpha-numeric string (a-z;A-Z;0-9;.-_)";
					throw message;
				}
			}
			}
		}


} //end of namespace DESpot
