/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once
#include "ProjectEditor.h"
#include "FlatProjectWorkspace.h"
#include "DistHandler.h"
#include "FaultTolerant.h"
#ifdef __ENABLE_DIST__
#include <unistd.h>
#include <sys/time.h>
#endif

namespace DESpot
{
	class MainForm;
	class DesFlatProject;

	class FlatProjectEditor: public ProjectEditor
	{
		Q_OBJECT

		public:
			FlatProjectEditor(const QString& projName, MainForm* pMainForm);
			FlatProjectEditor(DesProject* project, MainForm* pMainForm);
			virtual ~FlatProjectEditor(void);
		
		// Added by RJL - remove when bddsd
		//integrated with despot
		//Implementation methods
		protected:
			bool attemptExportToBDDsd();

		// remove to here - RJL

		protected slots:
			virtual void onAddDes();
			virtual void onCheckProjectIntegrity();			
			virtual void onCheckProject();
			
//==================================================================================================================================================
			virtual void onRunSaveFaultsTool();
			virtual void onRunSaveFaultsSetsTool();
		// Added by Amal for FT Ctrl
			virtual void onRunDFTCtrlTool();
			virtual void onRunNFFTCtrlTool();
			virtual void onRunNonRepFTCtrlTool();
			virtual void onRunResettableFTCtrlTool();
//___________________________________________________________________________________________________________________________________________________
		// Added by Amal for Timed FT Ctrl
			virtual void onRunTimedDFTCtrlTool();
			virtual void onRunTimedNFFTCtrlTool();
			virtual void onRunTimedNonRepFTCtrlTool();
			virtual void onRunTimedResettableFTCtrlTool();
//___________________________________________________________________________________________________________________________________________________
		// Added by Amal for FT NonBlocking
			virtual void onRunDFTNonBlockTool();
			virtual void onRunNFFTNonBlockTool();
			virtual void onRunNonRepFTNonBlockTool();
			virtual void onRunResettableFTNonBlockTool();
//==================================================================================================================================================
			//Added by Adam for bddExport

			void onExportToBDDsd();

			//Added by Adam for BDD Tools
			#ifdef __ENABLE_BDD__
			void onRunBddCheckAllTool();
			void onRunBddNonblockingTool();
			void onRunBddControllabilityTool();
			void onRunBddNBControllabilityTool();
			void onRunBddTDESControllabilityTool();
			void onRunBddSDControllabilityTool();
			void onRunBddProperTimebehaviorTool();
			void onRunBddSSingularProhibitableBehaviorTool();
			void onRunBddPlantCompletenessTool();
			void onRunBddALFTool();
			//Added by Amal for FT Ctrl.
			void onRunBDDDFTCtrlTool();
			void onRunTimedBDDDFTCtrlTool();
			void onRunBDDNFFTCtrlTool();
			void onRunTimedBDDNFFTCtrlTool();
			void onRunBDDNonRepFTCtrlTool();
			void onRunTimedBDDNonRepFTCtrlTool();
			void onRunBDDResettableFTCtrlTool();
			void onRunTimedBDDResettableFTCtrlTool();
			//Added by Amal for FT Nonblocking
			void onRunBDDDFTNonBlockTool();
			void onRunBDDNFFTNonBlockTool();
			void onRunBDDNonRepFTNonBlockTool();
			void onRunBDDResettableFTNonBlockTool();
                        #endif

			//Added by David for Distributed Tools
			void onRunDistCheckAll();
//add by bini
			void onInstantiateTemplate();
			void onDeleteInstantiation(bool askConfirm = true);
			void onRegenerateInstantiation();
			void onEditInst();

		private:
			DesFlatProject* project();
			FlatProjectWorkspace* workspace();
			// Added by Amal for FT
			FaultTolerant m_faultTolerant;

			void setupConnections();
	};

} //end of namespace DESpot
