/*************************************************************************
 * This file is part of the Distributed Computation feature
 *
 * Project created in conformity with the requirements for the Degree of
 * Master of Engineering in Software Engineering, Computing and Software
 * Department, McMaster University 2012
 *
 * Author:	David Kirby
 * Supervisor: Dr. Ryan Leduc
 *
 * Description: A wrapper class that bundles the host object, a boolean lock,
 * and a unique ID together for easy host management.
 ************************************************************************/
#pragma once

#include "CommonDefinitions.h"

#ifdef __ENABLE_DIST__
#include <mpi.h>
#endif

namespace DESpot
{
	class Host
	{
		public: 
			Host(int id);
			
			#ifdef __ENABLE_DIST__
			MPI_Comm* getHost();
			#endif

			bool isLocked();
			void setLock(bool lock);

			int getID();			

		private:
			// The remote host
			#ifdef __ENABLE_DIST__
			MPI_Comm host;
			#endif
		
			bool locked;

			// unique identifying number
			int ID;		
	};
}
