/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007


	Modified by Xu Han
*/
#pragma once

#include <string>
#include "MultiCtrlAlgo.h"
#include "DesHierProject.h"
#include "OutputUiPart.h"

namespace DESpot
{
	class IConsistAnsAcceptAlgo : public MultiCtrlAlgo
	{
		public:
			IConsistAnsAcceptAlgo(DesHierProject& project);
			virtual ~IConsistAnsAcceptAlgo(void);

		public:
			virtual bool runAlgo();

			bool allAnsEventsAccepted();

			std::wstring getError();

			DesHierProject& getInputProject();

		public:
			virtual void prepareRun();
		    virtual void onEventBlocked(short eventId,  SrcStateTuple& srcStateTuple, short iSrc);
			bool isHighLevelDes(const Des* pDes, short iSrc);

		public:
			DesHierProject& m_project;

		public:
			static const std::wstring cIConsistAnsAcceptAlgoDesc;
			static const std::wstring cIConsistAcceptError;
			static const std::wstring cIConsistAnsAcceptError;
			static const std::wstring cIConsistLdAnsAcceptError;
	};
}
