/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include "CommonDefinitions.h"
#include <string>

namespace DESpot
{
	class NameValidator
	{
		public:
			NameValidator(NameValidator* nextValidator = null) : m_next(nextValidator)
			{
			}

                        virtual ~NameValidator(void)
			{
				if (m_next)
				{
					delete m_next;
					m_next = null;
				}
			}

		public:

			virtual bool validate(const std::wstring& name)
			{
				for(unsigned int iChar = 0; iChar < name.size(); iChar++)
				{
					if (validateCharacter(iChar, name[iChar]) == false)
					{
						return false;
					}
				}

				return true;
			}

//add by bini
			virtual bool validate2(std::wstring& name)
			{
				for(unsigned int iChar = 0; iChar < name.size(); iChar++)
				{
					if (validateCharacter(iChar, name[iChar]) == false)
					{
						return false;
					}
				}

				return true;
			}
 

			virtual bool validateCharacter(unsigned int iChar, wchar_t character)
			{
				if (m_next)
				{
					return m_next->validateCharacter(iChar, character);
				}
				else
				{
					return true;
				}
			}

		protected:
			NameValidator* m_next;
	};

	class AlphaNumValidator : public NameValidator
	{
		public:
			AlphaNumValidator(NameValidator* nextValidator = null) : NameValidator(nextValidator)
			{
			}

                        virtual ~AlphaNumValidator()
                        {
                        }

		public:
			virtual bool validateCharacter(unsigned int iChar, wchar_t character)
			{
				bool isValid = iswalnum(character);

				if (!isValid && m_next)
				{
					//give the character to the next validator in line to apply its validation rule
					isValid = isValid || m_next->validateCharacter(iChar, character);
				}

				return isValid;
			}
	};

	class DotValidator : public NameValidator
	{
		public:
			DotValidator(NameValidator* nextValidator = null) : NameValidator(nextValidator)
			{
			}

                        virtual ~DotValidator()
                        {
                        }

		public:
			virtual bool validateCharacter(unsigned int iChar, wchar_t character)
			{
				bool isValid = (character == L'.');

				if (!isValid && m_next)
				{
					//give the character to the next validator in line to apply its validation rule
					isValid = isValid || m_next->validateCharacter(iChar, character);
				}

				return isValid;
			}
	};

	class WordSepValidator : public NameValidator
	{
		public:
			WordSepValidator(NameValidator* nextValidator = null) : NameValidator(nextValidator)
			{
			}

                        virtual ~WordSepValidator()
                        {
                        }

		public:
			virtual bool validateCharacter(unsigned int iChar, wchar_t character)
			{
				bool isValid = (character == L'_') || (character == L'-');

				if (!isValid && m_next)
				{
					//give the character to the next validator in line to apply its validation rule
					isValid = isValid || m_next->validateCharacter(iChar, character);
				}

				return isValid;
			}
	};
//add by bini
	class PercentValidator : public NameValidator
	{
		public:
			PercentValidator(NameValidator* nextValidator = null) : NameValidator(nextValidator)
			{
			}

                        virtual ~PercentValidator()
                        {
                        }

		public:
			virtual bool validateCharacter(unsigned int iChar, wchar_t character)
			{
				bool isValid = (character == L'%');

				if (!isValid && m_next)
				{
					//give the character to the next validator in line to apply its validation rule
					isValid = isValid || m_next->validateCharacter(iChar, character);
				}

				return isValid;
			}
	};

	class CommaValidator : public NameValidator
	{
		public:
			CommaValidator(NameValidator* nextValidator = null) : NameValidator(nextValidator)
			{
			}

                        virtual ~CommaValidator()
                        {
                        }

		public:
			virtual bool validateCharacter(unsigned int iChar, wchar_t character)
			{
				bool isValid = (character == L',');

				if (!isValid && m_next)
				{
					//give the character to the next validator in line to apply its validation rule
					isValid = isValid || m_next->validateCharacter(iChar, character);
				}

				return isValid;
			}	
	};


	class BracketValidator : public NameValidator
	{
		public:
			BracketValidator(NameValidator* nextValidator = null) : NameValidator(nextValidator)
			{
			}

                        virtual ~BracketValidator()
                        {
                        }

		public:
			virtual bool validateCharacter(unsigned int iChar, wchar_t character)
			{
				bool isValid = (character == L'('||character==L')');

				if (!isValid && m_next)
				{
					//give the character to the next validator in line to apply its validation rule
					isValid = isValid || m_next->validateCharacter(iChar, character);
				}

				return isValid;
			}	
	};





} //end of namespace DESpot
