/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2015
*/

#include <iostream>
#include <string> 
#include "NonRepFTAlgoTimed.h"
#include "TimedCtrl.h"
#include "FlatProjIntegrityAlgo.h"

namespace DESpot

{
NonRepFTAlgoTimed::NonRepFTAlgoTimed(const DesProject& currentProject, QList<QString>& faultSet ,int M , int N , QMultiMap<int, QString>& faultSets):NonRepFTAlgo(currentProject,faultSet,M,N,faultSets), m_isTimedNonRepFaultsControllable(false)
{
}
//____________________________________________________________________________________________________________________________________	
NonRepFTAlgoTimed::~NonRepFTAlgoTimed()
{
}
//____________________________________________________________________________________________________________________________________
bool NonRepFTAlgoTimed::runAlgo()
{

	DefaultFTAlgo::createDummyFlatProject();
	if (! m_faultSet.isEmpty())
	{	
		DefaultFTAlgo::constructGFTimed();
		DefaultFTAlgo::addGF();
	}
	std::cout << "m_N" << m_N << endl;
	std::cout << "m_M" << m_M << endl;
	if (m_N < m_M)
	{
		NonRepFTAlgoTimed::constructGNF();
		NonRepFTAlgo::addGNF();
	}
	if (m_N > 0)
	{
		NonRepFTAlgoTimed::constructGFi();
	}
	return NonRepFTAlgoTimed::verifyFTCtrl();

}
//____________________________________________________________________________________________________________________________________
void NonRepFTAlgoTimed::constructGNF()
{
	if (! m_faultSets.empty())
	{
		
		const std::wstring& name = L"GNF" ;
		GNFDes = new Des(name , eRegularDes);
		
		DesState* InState = new DesState(0);

		InState->setIDasName();
		const DesState& Instate = GNFDes->addState(const_cast<DesState&>(*InState));
		GNFDes->changeStateMarking(Instate.getId(),true);
		GNFDes->changeStateInit(Instate.getId(),true);

		DesEvent* tickEvent = new DesEvent();
		const std::wstring& tickName = L"tick" ;
		const std::wstring& aliasName = L"t" ;
		tickEvent->setName(tickName);
		tickEvent->setAlias(aliasName);
		tickEvent->setControllable(true);
		const DesEvent& tickDESEvent = GNFDes->addEvent(const_cast<DesEvent&>(*tickEvent));
		GNFDes->addSelfTransition(tickDESEvent);

		QList<QString> faultEvents = m_faultSets.values();
		for (int i=0 ; i < faultEvents.size() ; i++)
		{ 
			QString eventName = faultEvents.at(i);
			const DesEvent* event;
			DesProject::DesIteratorPtr DESIt = m_currentProject.createDesIterator();
			for(DESIt->first(); DESIt->isDone() == false; DESIt->next())
			{
				const Des& currentDes = DESIt->currentItem();
				if (currentDes.findEvent(eventName.toStdWString(),event))
				{
					GNFDes->addEvent(const_cast<DesEvent&>(*event));
					break;
				}
			}
		}
	
		for (int j=1 ; j <= m_N ; j++)
		{
			const DesState& preState = GNFDes->getState(GNFDes->getLastUsedStateId());
			DesState* newState = new DesState(j+1);
			newState->setIDasName();
			const DesState& state = GNFDes->addState(const_cast<DesState&>(*newState));
			GNFDes->changeStateMarking(state.getId(),true);
			Des::EventIteratorPtr eventIt = GNFDes->createEventIterator();
			for(eventIt->first(); eventIt->isDone() == false; eventIt->next())
			{
				const DesEvent& event = eventIt->currentItem();
				DesTransition* trans = new DesTransition(preState , event , state);
				GNFDes->addTransition(const_cast<DesTransition&>(*trans));
			}		
		}
	}
cout << "End GNF" << endl;
}
//____________________________________________________________________________________________________________________________________
void NonRepFTAlgoTimed::constructGFi()
{
	if (! m_faultSets.empty())
	{
		int i = 1;
		while ( i <= m_M)
		{
			string temp;
			ostringstream convert;
			convert << i;
			temp = convert.str();
			std::wstring wsi;
			std::wstring wsi2 = L"GFi";
			wsi.assign(temp.begin(), temp.end());
			wsi2.append(wsi);
			const std::wstring& name =wsi2;
			Des* GFiDes;
			GFiDes = new Des(name , eRegularDes);


			//const std::wstring& name = L"GFi" ;
			//GFiDes = new Des(name , eRegularDes);

			DesState* state1 = new DesState(0);
			state1->setIDasName();
			const DesState& InState1 = GFiDes->addState(const_cast<DesState&>(*state1));
			GFiDes->changeStateMarking(InState1.getId(),true);
			GFiDes->changeStateInit(InState1.getId(),true);

			DesState* state2 = new DesState(1);
			state2->setIDasName();
			const DesState& InState2 = GFiDes->addState(const_cast<DesState&>(*state2));
			GFiDes->changeStateMarking(InState2.getId(),true);

			DesEvent* tickEvent = new DesEvent();
			const std::wstring& tickName = L"tick" ;
			const std::wstring& aliasName = L"t" ;
			tickEvent->setName(tickName);
			tickEvent->setAlias(aliasName);
			tickEvent->setControllable(true);
			const DesEvent& tickDESEvent = GFiDes->addEvent(const_cast<DesEvent&>(*tickEvent));
			GFiDes->addSelfTransition(tickDESEvent);

			QList<QString> faultEvents = m_faultSets.values(i);
			for (int j=0 ; j < faultEvents.size() ; j++)
			{ 	
				QString eventName = faultEvents.at(j);
				const DesEvent* event;
				DesProject::DesIteratorPtr DESIt = m_currentProject.createDesIterator();
				for(DESIt->first(); DESIt->isDone() == false; DESIt->next())
				{
					const Des& currentDes = DESIt->currentItem();
					if (currentDes.findEvent(eventName.toStdWString(),event))
					{	
						const DesEvent& newEvent = GFiDes->addEvent(const_cast<DesEvent&>(*event));
						DesTransition* trans = new DesTransition(InState1 , newEvent , InState2);
						GFiDes->addTransition(const_cast<DesTransition&>(*trans));
						break;
					}
				}
			}
			NonRepFTAlgo::addGFi(GFiDes);
			i++;
		}
cout << "End GNFi" << endl;
	}
	else if (m_faultSets.empty())
		{throw EX("Fault Events List is empty.");}
}
//____________________________________________________________________________________________________________________________________
bool NonRepFTAlgoTimed::verifyFTCtrl()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		TimedCtrl tCtrlAlgo(m_flatDummyProject->createDesIterator(ePlantDes),m_flatDummyProject->createDesIterator(eSupervisorDes));
		m_isTimedNonRepFaultsControllable = m_flatDummyProject->checkTimedControllable(tCtrlAlgo);
cout << "m_isTimedNonRepFaultsControllable= " << m_isTimedNonRepFaultsControllable << endl;
		return m_isTimedNonRepFaultsControllable;

	}
	else
	{throw EX("Project Integrity test has failed");}
	return m_isTimedNonRepFaultsControllable;
}
//____________________________________________________________________________________________________________________________________
bool NonRepFTAlgoTimed::isTimedNonRepFaultsControllable() const
{
	return m_isTimedNonRepFaultsControllable;
}
//____________________________________________________________________________________________________________________________________
}


