#pragma once

#include <map>
#include "Iterator.h"
#include "CommonDefinitions.h"
#include "DecObserver.h"

namespace DESpot
{
    class ObserverIterator : public Iterator<DecObserver&, const DecObserver&>
    {
    public:
        ObserverIterator(const std::map<std::wstring, DecObserver*>& obsvMap):
                m_ObsvMap(obsvMap)
        {
        }

        virtual ~ObserverIterator(void)
        {
        }

    public:
        virtual void first() const
        {
            m_crtObsvIt = m_ObsvMap.begin();
        }

        virtual void next() const
        {
            m_crtObsvIt++;
        }

        virtual bool isDone() const
        {
            return (m_crtObsvIt == m_ObsvMap.end());
        }

        virtual DecObserver& currentItem()
        {
            if(m_crtObsvIt == m_ObsvMap.end())
                throw EX("Iterator is already done. Call isDone() before.")

            return const_cast<DecObserver&>(*(m_crtObsvIt->second));
        }

        virtual const DecObserver& currentItem() const
        {
            if(m_crtObsvIt == m_ObsvMap.end())
                throw EX("Iterator is already done. Call isDone() before.")

            return *(m_crtObsvIt->second);
        }

    private:
        ObserverIterator(const ObserverIterator& other) : m_ObsvMap(other.m_ObsvMap){}
        ObserverIterator& operator=(const ObserverIterator&)
        {
            return *this;
        }

    private:
        typedef std::map<std::wstring, DecObserver*> ObserverMap;
        typedef ObserverMap::const_iterator ObserverMapIt;

    private:
        const ObserverMap m_ObsvMap;
        mutable ObserverMapIt m_crtObsvIt;
    };
}
