#pragma once

#include <map>
#include "Iterator.h"
#include "CommonDefinitions.h"
#include "DecEvent.h"

namespace DESpot
{
    class ObserverObsEventIterator: public Iterator<DecEvent&, const DecEvent&>
    {
    public:
        ObserverObsEventIterator(const std::map<std::wstring, DecEvent*>& obsvObsEventMap):
                m_ObsvObsEventMap(obsvObsEventMap)
        {
        }

        virtual ~ObserverObsEventIterator(void)
        {
        }

    public:
        virtual void first() const
        {
            m_crtObsvObsEventIt = m_ObsvObsEventMap.begin();
        }

        virtual void next() const
        {
            m_crtObsvObsEventIt++;
        }

        virtual bool isDone() const
        {
            return (m_crtObsvObsEventIt == m_ObsvObsEventMap.end());
        }

        virtual DecEvent& currentItem()
        {
            if(m_crtObsvObsEventIt == m_ObsvObsEventMap.end())
                throw EX("Iterator is already done. Call isDone() before.")

            return const_cast<DecEvent&>(*(m_crtObsvObsEventIt->second));
        }

        virtual const DecEvent& currentItem() const
        {
            if(m_crtObsvObsEventIt == m_ObsvObsEventMap.end())
                throw EX("Iterator is already done. Call isDone() before.")

            return *(m_crtObsvObsEventIt->second);
        }

    private:
        ObserverObsEventIterator(const ObserverObsEventIterator& other) : m_ObsvObsEventMap(other.m_ObsvObsEventMap){}
        ObserverObsEventIterator& operator=(const ObserverObsEventIterator&)
        {
            return *this;
        }

    private:
        typedef std::map<std::wstring, DecEvent*>ObsvObsEventMap;
        typedef ObsvObsEventMap::const_iterator ObsvObsEventMapIt;

    private:
        const ObsvObsEventMap m_ObsvObsEventMap;
        mutable ObsvObsEventMapIt m_crtObsvObsEventIt;
    };
}
