/*************************************************************************
 * This file is part of the Distributed Computation feature
 *
 * Project created in conformity with the requirements for the Degree of
 * Master of Engineering in Software Engineering, Computing and Software
 * Department, McMaster University 2012
 *
 * Author:	David Kirby
 * Supervisor: Dr. Ryan Leduc
 ************************************************************************/
#include "SpawnWrapper.h"

namespace DESpot
{
	void SpawnWrapper::spawnSlave(Host* target)
	{
#ifdef __ENABLE_DIST__
		int flag = 0;
		MPI_Initialized(&flag);
		if (!flag) 
		{
			MPI_Init(NULL,NULL);
		}

		MPI_Info hostinfo;
		MPI_Info_create(&hostinfo);  		
		MPI_Info_set(hostinfo, "hostfile", &(HostFileManager::getHostFileName()[0]));

		int err[4];
		MPI_Comm* host = target->getHost();
		MPI_Comm_spawn("DESpotMPISlave", NULL, 1, hostinfo, 0, MPI_COMM_WORLD, host, err);
#endif
	}
}
