/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2015
*/

#pragma once
#include <string>
#include <vector>
#include "TimedCtrl.h"
#include <ctime>

namespace DESpot
{

TimedCtrl::TimedCtrl(void)
{
}
//____________________________________________________________________________________________________________________________________

TimedCtrl::TimedCtrl(DesProject::DesIteratorPtr plantDesIt, DesProject::DesIteratorPtr supDesIt) : MultiCtrlAlgo(plantDesIt, supDesIt)
{
}
//____________________________________________________________________________________________________________________________________

TimedCtrl::~TimedCtrl(void)
{
		if(tranMap!=null)
		{
			delete tranMap;
			tranMap=null;
		}
		if(turpleStorage!=null)
		{
			delete turpleStorage;
			turpleStorage=null;
		}
		if(main_pendinglist!=null)
		{
			delete main_pendinglist;
			main_pendinglist=null;
		}
}
//____________________________________________________________________________________________________________________________________

bool TimedCtrl::runTDESAlgo()
{
	try
	{	
		TimedCtrl::runAlgo();
		return m_isTControllable = true; // "=" is intentional
	}
	catch(CtrlException& ctrlEx)
	{
		m_unctrlBehaviour.set(ctrlEx.unctrlSupDes, ctrlEx.unctrlSupState, ctrlEx.srcStateTuple, &ctrlEx.blockedEvent);

		std::wstring error = prepareErrorDescription();
		addError(error);

		return m_isTControllable = false; // "=" is intentional
	}

}// end of function runTDESAlgo()
//____________________________________________________________________________________________________________________________________

bool TimedCtrl::runAlgo()
{
	if (m_integrity == false)
	{
		throw EX("Either project is not valid, or integrity \
has not yet been checked.");
		 return false;
	}

	TimedCtrl::prepareRun();

	short tickEventNum;
	short tickDesNum;
	bool forcibleEventPossible;
	bool tickEventBlocked;
	while(main_pendinglist->isEmpty()==false)
	{
		SrcStateTuple crtSrcStateTuple(DesNum);
		main_pendinglist-> PopPending(crtSrcStateTuple);
		forcibleEventPossible = false;
		tickEventBlocked = false ;
	// the code you wish to time goes here
		for(short i=1; i<EventNum ;i++)
		{ 
			SrcStateTuple temptuple(DesNum); 
			for(short j=0;j<DesNum;j++)
			{
				short from_state = crtSrcStateTuple[j];
				short to_state = transitionMatrix[j][i][from_state];
				 
				if(to_state!=-1)
				{
					temptuple[j]=to_state; 
				}
				else
				{
					MultiCtrlAlgo::onEventBlocked(i,crtSrcStateTuple,j);
					if (! tickEventBlocked)
					{
						if (TimedCtrl::isTickEvent(i,j))
						{
							tickEventBlocked = true;
							//cout << "in loop tickEventBlocked  = " << tickEventBlocked  << endl;
							tickEventNum = i;
							tickDesNum = j;
						}
					}
					break;
				}
				if(j==DesNum-1)
				{ 
	 				
					if (! forcibleEventPossible)
						{forcibleEventPossible = TimedCtrl::isForcibleEvent(i,j);}
				// at end of the entry; the whole tuple is finished
					if(turpleStorage->search(&temptuple)==false)
					{
						turpleStorage->insert(&temptuple);
						main_pendinglist->PushPending(temptuple);
					}
				}
			}
		}
		//cout << "tickEventBlocked  = " << tickEventBlocked  << endl;
		//cout << "forcibleEventPossible = " << forcibleEventPossible << endl;
		if (tickEventBlocked && !forcibleEventPossible)
		{
			//cout << "tickEventBlocked and no forcibleEventPossible" << endl;
			TimedCtrl::onEventBlocked(tickEventNum,crtSrcStateTuple,tickDesNum);
			break;
		}

	}//end while loop
	delete main_pendinglist;
	main_pendinglist=null;
	//cout << "is controllable" << endl;
	return true;
}// end of function runAlgo()
//____________________________________________________________________________________________________________________________________
void TimedCtrl::prepareRun()
{
	MultiCtrlAlgo::prepareRun();
	m_isTControllable = false;
	TimedCtrl::isFlatProjectTimed();
}// end of function prepareRun()
//____________________________________________________________________________________________________________________________________
void TimedCtrl::isFlatProjectTimed()
{
	std::wstring tName = L"tick";
	std::wstring tAlias = L"t";
	bool fndEvent;

	for (unsigned int iDes = 0; iDes < m_inDesSet.size() ; ++iDes)
	{
		fndEvent = false;
		const Des* des = m_inDesSet[iDes];
		if (des->getIntegrity() != eIntegYes)
		{			
			throw EX("Either all DES are not valid, or integrity has not yet been checked.");
		}
		const DesEvent* event;
		if (des->findEvent(tName,event))
		{
			std::wstring tmpAlias = event->getAlias();
			if ((tAlias == tmpAlias) && (event->isControllable()))
			{
				fndEvent = true;
			}
		}
		if (!fndEvent)
		{
			throw EX("TDES controllability tool \
requires that every DES contain a controllable event named \"tick\" with alias\
 \"t\" ");
			break;
		}

	}
}// end of function isFlatProjectTimed()
//____________________________________________________________________________________________________________________________________
inline bool TimedCtrl::isForcibleEvent(short eventId, short iSrc)
{
	DesEvent* event= tranMap->getEvent(eventId);
	std::wstring tName = L"tick";
	if (iSrc>= m_supCriteria && (tranMap->isControllable(eventId) == true) && !(event->getName() == tName))
	{return true;}
	else
	{return false;}
}// end of function isForcibleEvent(short eventId)
//____________________________________________________________________________________________________________________________________
inline bool TimedCtrl::isTickEvent(short eventId,short iSrc )
{
	DesEvent* event= tranMap->getEvent(eventId);
	std::wstring tName = L"tick";

	if (iSrc>= m_supCriteria  && (tranMap->isControllable(eventId) == true) && (event->getName() == tName))
	{return true;}
	else
	{return false;}
}// end of function isTickEvent(short eventId)
//____________________________________________________________________________________________________________________________________
void TimedCtrl::onEventBlocked(short eventId,  SrcStateTuple& srcStateTuple, short iSrc)
{
//similar to onEventBlocked function in the MultiCtrl class without isControllable check
	const Des* blockingDes = m_inDesSet[iSrc];
	short state_id = srcStateTuple[iSrc];
	const DesState& blockingState = blockingDes->getState(state_id);

	DesEvent* blockedEvent=tranMap->getEvent(eventId);
	StateTuple *tmp=new StateTuple(m_inDesSet.size());

	for(int i=0;i<(int)m_inDesSet.size();i++)
	{
		short theid= srcStateTuple[i];
		(*tmp)[i]=&(m_inDesSet[i]->getState((unsigned long long)theid));
	}
	//Added by zain for counter example generation
	if(isfirsterror==true)
	{
		for(int i=0;i<(int)m_inDesSet.size();i++)
		{
			this->CE_tuplemap[m_inDesSet[i]->getName()]=srcStateTuple[i];
		}				
		isfirsterror=false;
	}
	throw CtrlException(blockingDes, &blockingState, *blockedEvent, *tmp);
}// end of function onEventBlocked(short eventId,  SrcStateTuple& srcStateTuple, short iSrc)
//____________________________________________________________________________________________________________________________________
}//end of namespace DESpot
