/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2015
*/

#pragma once
//#include <iostream>
#include "BDDDefaultFTAlgo.h"
#include "Des.h"
#include "DesFlatProject.h"
#include "FlatDummyProject.h"
#include "MultiCtrlAlgo.h"
#include "FlatProjIntegrityAlgo.h"
#include "BddSdMain.h"

namespace DESpot
{
BDDDefaultFTAlgo::BDDDefaultFTAlgo(const DesProject& currentProject, QList<QString>& currentFaultSet): DefaultFTAlgo(currentProject, currentFaultSet),m_isBDDDFTControllable(false)
{
	GFDes = NULL;
	m_flatDummyProject = NULL;
}
//____________________________________________________________________________________________________________________________________	
BDDDefaultFTAlgo::~BDDDefaultFTAlgo()
{
}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_CtrlChkInfo BDDDefaultFTAlgo::runBDDFTCtrlAlgo()
{

	// check that excluded fault set is valid
	if (! (m_currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	if (! m_faultSet.isEmpty())	
	{
		DefaultFTAlgo::createDummyFlatProject();
		DefaultFTAlgo::constructGF();
		DefaultFTAlgo::addGF();
		return BDDDefaultFTAlgo::verifyBDDFTCtrl();
	}
	else
	{throw EX("There are no excluded fault events. Please run the standard controllability algorithm.");}
}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_CtrlChkInfo BDDDefaultFTAlgo::verifyBDDFTCtrl()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		int tmp;
		BDDSD::SD_CtrlChkInfo  checkInfo("Project passes Untimed Controllability Check");
      		tmp = BddSdCheckCtrl((DesProject&) *m_flatDummyProject, checkInfo);

     		if (checkInfo.m_chkPassed)
			m_isBDDDFTControllable = true;
		else
			m_isBDDDFTControllable = false;

		return checkInfo;
	}
	else
	{throw EX("Project Integrity test has failed");}
}
//____________________________________________________________________________________________________________________________________
bool BDDDefaultFTAlgo::isBDDDFTControllable() const
{
	return m_isBDDDFTControllable;
}
//____________________________________________________________________________________________________________________________________
}


