/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2016
*/
#pragma once
#include <iostream>
#include "BDDNFaultsAlgoTimed.h"
//#include "DefaultFTAlgoTimed.h"
//#include "DefaultFTAlgo.h"
#include "Des.h"
#include "DesProject.h"
#include "FlatDummyProject.h"
#include "FlatProjIntegrityAlgo.h"
#include "BddSdMain.h"


namespace DESpot

{
BDDNFaultsAlgoTimed::BDDNFaultsAlgoTimed(const DesProject& currentProject, QList<QString>& faultSet, int N , QMultiMap<int,QString>& faultSets): NFaultsAlgoTimed(currentProject, faultSet, N, faultSets), m_isTimedBDDNFaultsControllable(false)
{
	GNFDes = NULL;
}
//____________________________________________________________________________________________________________________________________	
BDDNFaultsAlgoTimed::~BDDNFaultsAlgoTimed()
{
}
//____________________________________________________________________________________________________________________________________

BDDSD::SD_TCtrlChkInfo BDDNFaultsAlgoTimed::runTimedBDDFTCtrlAlgo()
{
	DefaultFTAlgo::createDummyFlatProject();
	if (! m_faultSet.isEmpty())
	{
		DefaultFTAlgo::constructGFTimed();	
		DefaultFTAlgo::addGF();
	}
	int m = m_faultSets.uniqueKeys().size();
	if (m_N < m)
	{
		NFaultsAlgoTimed::constructGNF();
		NFaultsAlgo::addGNF();
	}	
	return BDDNFaultsAlgoTimed::verifyTimedBDDFTCtrl();
}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_TCtrlChkInfo BDDNFaultsAlgoTimed::verifyTimedBDDFTCtrl()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		int tmp;
		BDDSD::SD_TCtrlChkInfo  checkInfo("Project passes Untimed Controllability Check");
      		tmp = BddSdCheckTCtrl((DesProject&) *m_flatDummyProject, checkInfo);
     		if (checkInfo.m_chkPassed)
			m_isTimedBDDNFaultsControllable = true;
		else
			m_isTimedBDDNFaultsControllable = false;

		return checkInfo;
	}
	else
	{throw EX("Project Integrity test has failed");}

}
//____________________________________________________________________________________________________________________________________
bool BDDNFaultsAlgoTimed::isTimedBDDNFaultsControllable() const
{return m_isTimedBDDNFaultsControllable;}

}


