/*	Author:	Dr. Ryan Leduc
	
*/
#pragma once
#include <iostream>
#include "BDDNonRepFTAlgoTimed.h"
//#include "DefaultFTAlgoTimed.h"
//#include "DefaultFTAlgo.h"
#include "Des.h"
#include "DesProject.h"
#include "FlatDummyProject.h"
#include "FlatProjIntegrityAlgo.h"
#include "BddSdMain.h"


namespace DESpot
{
BDDNonRepFTAlgoTimed::BDDNonRepFTAlgoTimed(const DesProject& currentProject, QList<QString>& faultSet ,int M, int N , QMultiMap<int,QString>& faultSets) : NonRepFTAlgoTimed(currentProject, faultSet , M , N , faultSets), m_isTimedBDDNonRepFTControllable(false)
{
}
//____________________________________________________________________________________________________________________________________	
BDDNonRepFTAlgoTimed::~BDDNonRepFTAlgoTimed()
{
}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_TCtrlChkInfo BDDNonRepFTAlgoTimed::runTimedBDDFTCtrlAlgo()
{
	DefaultFTAlgo::createDummyFlatProject();
	if (! m_faultSet.isEmpty())
	{	
		DefaultFTAlgo::constructGFTimed();
		DefaultFTAlgo::addGF();
	}
	if (m_N < m_M)
	{
		NonRepFTAlgoTimed::constructGNF();
		NonRepFTAlgo::addGNF();
	}
	if (m_N > 0)
	{
		NonRepFTAlgoTimed::constructGFi();
	}
	return BDDNonRepFTAlgoTimed::verifyTimedBDDFTCtrl();
}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_TCtrlChkInfo BDDNonRepFTAlgoTimed::verifyTimedBDDFTCtrl()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		int tmp;
		BDDSD::SD_TCtrlChkInfo  checkInfo("Project passes Untimed Controllability Check");
      		tmp = BddSdCheckTCtrl((DesProject&) *m_flatDummyProject, checkInfo);
     		if (checkInfo.m_chkPassed)
			m_isTimedBDDNonRepFTControllable = true;
		else
			m_isTimedBDDNonRepFTControllable = false;

		return checkInfo;
	}
	else
	{throw EX("Project Integrity test has failed");}

}
//____________________________________________________________________________________________________________________________________
bool BDDNonRepFTAlgoTimed::isTimedBDDNonRepFTControllable() const
{return m_isTimedBDDNonRepFTControllable;}
}



