#pragma once

#include "newSyncAlgo.h"
#include "DesProject.h"
#include "DecObserver.h"


namespace DESpot
{	
	class CoObsAlgo : public newSyncAlgo
	{
		public:
			typedef std::vector<short> SrcEventTuple;

		public:
			CoObsAlgo(DesProject* project);
			virtual ~CoObsAlgo(void);
		
		public:
			void addDecObserver(DesProject::ObserverIteratorPtr obsvIt);
			void addDecObserver(const DecObserver* obsv);
			void addInputPlantDes(DesProject::DesIteratorPtr plantDesIt);
			void addInputPlantDes(const Des* inPlantDes);
			void addInputSupDes(DesProject::DesIteratorPtr supDesIt);
			void addInputSupDes(const Des* inSupDes);

		public:
			virtual bool runAlgo();
			virtual void prepareRun();
			virtual void onEventBlocked(short eventId,  SrcStateTuple& srcStateTuple, short iSrc);
		
		public:
			void loadProductDes();
			void createInitialStateTuple();
		
		public:			
			bool isIllegalConfiguration(SrcStateTuple s, short eventId);
			SrcEventTuple& makeObsLabel(short eventId);
			SrcEventTuple& makeUnobsLabel(short eventId, short iDec);
			SrcStateTuple* calcNextState(SrcStateTuple s1, SrcEventTuple label);

		public:
			SrcStateTuple* getDesTransition(SrcStateTuple s1, short iDec, short eventId);
			bool hasPlantTransition(SrcStateTuple s1, short iDec, short eventId);
			bool hasSupTransition(SrcStateTuple s1, short iDec, short eventId);
		
		public:
			bool isCoObservable() const
			{
				return m_isCoObservable;
			}
			QString getCoObsError()
			{
				return m_CoObsError;
			}

		public:
			DesProject* m_project;
			DesSet m_inPlantDesSet;
			DesSet m_inSupDesSet;
			std::vector<const DecObserver*> m_observers;

			CoObsvLabelTrie* tupleEvent;
			CoObsvStateTrie* tupleState;
			PendingList* state_pendinglist;

			short m_numPlant;
			short m_numDec;

			bool m_isCoObservable;
			QString m_CoObsError;
	};

} //end of namespace DESpot
