#include <QHeaderView>
#include <QtCore>

#include "CommonDefinitions.h"
#include "DecDesEventSetListWidget.h"
#include "DecObserver.h"
#include "DesProject.h"
#include "DesSubsystem.h"
#include "DesInterface.h"

namespace DESpot
{
    DecDesEventSetListWidget::DecDesEventSetListWidget(QWidget* parent): QListWidget(parent)
    {
    }

    DecDesEventSetListWidget::~DecDesEventSetListWidget(void)
    {
    }

    void DecDesEventSetListWidget::loadObsData(DecObserver *obsv)
    {
        clear();
        DecObserver::ObserverObsEventIteratorPtr obsvIt = obsv->createObserverObsEventIterator();
        for(obsvIt->first(); obsvIt->notDone(); obsvIt->next())
        {
            const DecEvent& decEvent = obsvIt->currentItem();
            QString itemText = QString::fromStdWString(decEvent.getName());

            QListWidgetItem* item = new QListWidgetItem();
            item->setText(itemText);

            addItem(item);
        }
    }

    void DecDesEventSetListWidget::loadCtrlData(DecObserver *obsv)
    {
        clear();
        DecObserver::ObserverCtrlEventIteratorPtr obsvIt = obsv->createObserverCtrlEventIterator();
        for(obsvIt->first(); obsvIt->notDone(); obsvIt->next())
        {
            const DecEvent& decEvent = obsvIt->currentItem();
            QString itemText = QString::fromStdWString(decEvent.getName());

            QListWidgetItem* item = new QListWidgetItem();
            item->setText(itemText);

            addItem(item);
        }
    }

    void DecDesEventSetListWidget::loadCtrlEvents(DesProject *project, DecObserver *obsv)
    {
        clear();

        DesProject::EventIteratorPtr eventIt = project->createProjEventIterator();
        for(eventIt->first(); eventIt->isDone() == false; eventIt->next())
        {
            const ProjectEvent& event = eventIt->currentItem();
            if(event.isControllable() && obsv->findObsvCtrlEvent(event.getName()) == false)
            {
                QString itemText = QString::fromStdWString(event.getName());

                QListWidgetItem* item = new QListWidgetItem();
                item->setText(itemText);

                addItem(item);
            }
        }
    }

    void DecDesEventSetListWidget::loadObsEvents(DesProject *project, DecObserver *obsv)
    {
        clear();

        DesProject::EventIteratorPtr eventIt = project->createProjEventIterator();
        for(eventIt->first(); eventIt->isDone() == false; eventIt->next())
        {
            const ProjectEvent& event = eventIt->currentItem();
            if(obsv->findObsvObsEvent(event.getName()) == false)
            {
                QString itemText = QString::fromStdWString(event.getName());

                QListWidgetItem* item = new QListWidgetItem();
                item->setText(itemText);

                addItem(item);
            }
        }
    }
}
