#pragma once

#include <QListWidget>
#include <QString>
#include "CommonDefinitions.h"
#include "DecEvent.h"
#include "DecObserver.h"
#include "DesProject.h"
#include "DecEventViewerWidget.h"
#include "ProjectEvent.h"
#include "SubsystemEvent.h"
#include "InterfaceEvent.h"

namespace DESpot
{
    class DecObserver;
    class DesProject;

    class DecDesEventSetListWidget: public QListWidget
    {
	    public:
	        DecDesEventSetListWidget(QWidget* parent = null);
	        virtual ~DecDesEventSetListWidget(void);

	    public:
			virtual void loadObsData(DecObserver* obsv);
			virtual void loadCtrlData(DecObserver* obsv);

	    public:
	        void loadCtrlEvents(DesProject* project, DecObserver* obsv);
	        void loadObsEvents(DesProject* project, DecObserver* obsv);
    };
}
