#pragma once

#include<map>
#include<string>
#include<vector>
#include<QMap>

#include "Iterator.h"
#include "CommonDefinitions.h"

#include "DesTypes.h"
#include "DecEvent.h"
#include "ObserverCtrlEventIterator.h"
#include "ObserverObsEventIterator.h"
#include "ProjectEvent.h"

namespace DESpot
{
    class DesIntegrityAlgo;
    class DesSubsystem;

    class DecObserver
    {
        public:
            DecObserver(const std::wstring& name);
            ~DecObserver(void);

        public:
            std::wstring getName() const;
            void setName(const std::wstring& name);
            void setLoadInProgress(bool loadInProgress = true);
            bool m_bLoadInProgress;

            bool isModified() const;
            void setModified(bool isModified = true) ;
            void save();

            bool isEventModified() const;
            void setEventModified(bool isModified = true) ;

        private:
            //The name of the Observer
            std::wstring m_name;
            //observer has been modified since last saved
            mutable bool m_isModified;
            bool m_isEventModified;

        //EventInfo
        private:
            typedef std::map<std::wstring, DecEvent*> ObsvCtrlEventMap;
            typedef ObsvCtrlEventMap::iterator ObsvCtrlEventMapIt;
            typedef ObsvCtrlEventMap::const_iterator ObsvCtrlEventMapCIt;

            typedef std::map<std::wstring, DecEvent*> ObsvObsEventMap;
            typedef ObsvObsEventMap::iterator ObsvObsEventMapIt;
            typedef ObsvObsEventMap::const_iterator ObsvObsEventMapCIt;

        private:
            ObsvCtrlEventMap m_ObsvCtrlEventMap;
            ObsvObsEventMap m_ObsvObsEventMap;

        public:

            typedef Iterator<DecEvent&, const DecEvent&> ObserverCtrlEventIterator;
            typedef std::auto_ptr<const ObserverCtrlEventIterator>ObserverCtrlEventIteratorPtr;

            typedef Iterator<DecEvent&, const DecEvent&> ObserverObsEventIterator;
            typedef std::auto_ptr<const ObserverObsEventIterator>ObserverObsEventIteratorPtr;

        public:
            //Add Ctrl Events
            void addObsvCtrlEvent(DecEvent* ObsvCtrlEvent);
            const DecEvent& addCtrlEvent(const std::wstring& name);
            
            //Add Obsv Events
            const DecEvent& addObsEvent(const std::wstring &name);
            void addObsvObsEvent(DecEvent* ObsvObsEvent);

            bool findObsvObsEvent(const std::wstring &ObsvObsEventName) const;
            bool findObsvCtrlEvent(const std::wstring &ObsvCtrlEventName) const;

            void clearObsvCtrlEventlist();
            void clearObsvObsEventlist();

        public:
            bool checkexists();

        public:
            void deleteObsEvent(const std::wstring& name);
            void deleteCtrlEvent(const std::wstring& name);

        public:
            bool transExits(const std::wstring& name);

        public:
            ObserverCtrlEventIteratorPtr createObserverCtrlEventIterator() const;
            ObserverObsEventIteratorPtr createObserverObsEventIterator() const;
    };
}
