#pragma once

#include "DesProjectNotifications.h"
#include "ui_DecentralizedEventEditor.h"
#include "ProjectEvent.h"

#include <QListWidget>
#include <QString>

#include "CommonDefinitions.h"

#include "SubsystemEvent.h"
#include "DecEvent.h"
#include "InterfaceEvent.h"

namespace DESpot
{
    class DecentralizedEventEditor;
    class DesProject;
    class ProjectEvent;
    class DecObserver;

    class DecentralizedEventEditorUi: public QObject, public Ui::DecentralizedEventEdUI
    {
        Q_OBJECT

        public:
            DecentralizedEventEditorUi(Ui::DecentralizedEventEdUI* pUiContainer, DesProject* project);
            virtual ~DecentralizedEventEditorUi(void);

        private:
            void setupObserverWidget();
            void setupProjObsEventWidget();
            void setupProjCtrlEventWidget();
            void initWidgets(Ui::DecentralizedEventEdUI* pUiContainer);
            void setupConnections();

        private slots:
            void onAddProjectObsEventsToObserver();
            void onAddProjectCtrlEventsToObserver();
            void onRemoveObsEventsFromObserver();
            void onRemoveCtrlEventsFromObserver();
            void onObserverSelected(int index);

        private:
            DesProject* m_project;
            DecObserver* m_crtObsv;

        public:
            std::wstring getObsvName() const;

        private:
            std::wstring m_observerName;

        public:
            bool isModified() const;
            void setModified(bool isModified = true) ;
            void save();

        private:
            mutable bool m_isModified;
                
        private:
            DecDesEventSetListWidget* m_AvlObsEventsTreeWidget;
            DecDesEventSetListWidget* m_AvlCtrlEventsTreeWidget;
            DecDesEventSetListWidget* m_SelCtrlEventslistWidget;
            DecDesEventSetListWidget* m_SelObsEventslistWidget;

            QComboBox* m_ObservernamecomboBox;
            QPushButton* m_AddObsEvent;
            QPushButton* m_AddCtrlEvent;
            QPushButton* m_RemoveCtrlEvent;
            QPushButton* m_RemoveObsEvent;
    };
}

