/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2015
*/
#pragma once
#include "ui_FaultLists.h"
#include "DesFlatProject.h"
#include "DesEvent.h"
#include <QList>
#include <QMessageBox>
#include <QString>
#include <QWizard>
#include <QWizardPage>
#include <QPushButton>

namespace DESpot
{
	class FaultListsDlg : public QWizard , private Ui::FaultLists
	{
	 	Q_OBJECT

		public:
			FaultListsDlg(DesProject& currentProject, QList<QString>& currentnonFaultSet, QList<QString>& DFaultSet, QMultiMap<int, QString>& currentFaultSets, QMultiMap<int, QString>& currentResetableSets, QWidget* parent = 0);
			virtual ~FaultListsDlg(void);

		public:
			int getI();

		//Overridables
		protected:
			virtual bool validateCurrentPage();
			virtual int nextId() const;
			//virtual void back();

		private slots:
			void onAddFFaults();
			void onRemoveFFaults();
			bool onValidateFaults();
			void onAddTFaults();
			void onRemoveTFaults();


		//Implementation methods
		private:
			void listProjectEvents();
			void addNewFaultSetPage();

		private:
			DesProject& m_currentProject;
			int I;
			int origNumKeys;
			int pageCount;
			int key;
			QList<QString>& m_nonFaultSet;
			QList<QString>& m_DFaultSet;
			QMultiMap<int, QString>& m_faultSets;
			QMultiMap<int, QString>& m_resetSets;
			//QList<QString> m_projectEvents;
			bool validF = false;
			bool modifiedF = false;
			bool modifiedT = false;
			bool finish;
			//to create wizard page at run time
			QWizardPage *wizardPage;
    			QPushButton *RemoveFFaultsButton;
    			QPushButton *AddFFaultsButton;
			QPushButton *ValidateButton;
			QPushButton *RemoveTFaultsButton;
	    		QPushButton *AddTFaultsButton;
    			QLabel *label_4;
    			QGroupBox *groupBox_3;
			QGroupBox *groupBox_4;
    			QGroupBox *groupBox_5;
    			QGridLayout *gridLayout_3;
   			QGridLayout *gridLayout_4;
    			QGridLayout *gridLayout_5;
			QListWidget *FualtSetQListWidget;
   			QListWidget *ResetableSetQListWidget;
	};

} //end of namespace DESpot
