/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2015	
*/
#pragma once
#include "DesProject.h"
#include <QMultiMap>
#include <QList>
#include "DefaultFTAlgo.h"
#include "DefaultFTAlgoTimed.h"
#include "DefaultFTAlgoNonBlock.h"
#include "NFaultsAlgo.h"
#include "NFaultsAlgoTimed.h"
#include "NFaultsAlgoNonBlock.h"
#include "NonRepFTAlgo.h"
#include "NonRepFTAlgoTimed.h"
#include "NonRepFTAlgoNonBlock.h"
#include "ResetFTAlgo.h"
#include "ResetFTAlgoTimed.h"
#include "ResetFTAlgoNonBlock.h"

namespace DESpot
{

	class FaultTolerant
	{
	public:
		FaultTolerant();
		virtual ~FaultTolerant(void);

	public:
		void setNonFaultSet(DesProject& currentProject);
		void setDFaultSet(DesProject& currentProject , QWidget* parent = 0);
		void setFaultSets(DesProject& currentProject , QWidget* parent = 0);

		const QList<QString>& getNonFaultSet();
		const QList<QString>& getDFaultSet();
		const QMultiMap<int, QString>& getFaultSets();
		const QMultiMap<int, QString>& getResetableSets();

		//for Default FT Algo
		void runDFTCtrlTool(const DesProject& currentProject);
		inline bool isDFTControllable() {return m_isDFTControllable;}

		void runTimedDFTCtrlTool(const DesProject& currentProject);
		inline bool isTimedDFTControllable() {return m_isTimedDFTControllable;}

		void runDFTNonBlockTool(const DesProject& currentProject);
		inline bool isDFTNonBlocking() {return m_isDFTNonblocking;}
		
		//for N-fault FT Algo
		void runNFTCtrlTool(const DesProject& currentProject, int N, QWidget* parent = 0);
		inline bool isNFaultsControllable() {return m_isNFaultsControllable;}

		void runTimedNFTCtrlTool(const DesProject& currentProject, int N, QWidget* parent = 0);
		inline bool isTimedNFaultsControllable() {return m_isTimedNFaultsControllable;}

		void runNFTNonBlockTool(const DesProject& currentProject, int N, QWidget* parent = 0);
		inline bool isNFaultsNonblocking() {return m_isNFaultsNonblocking;}

		//for NonRepeatable FT Algo
		void runNonRepNFTCtrlTool(const DesProject& currentProject, int N, QWidget* parent = 0);
		inline bool isnonRepFaultsControllable() {return m_isnonRepFaultsControllable;}

		void runTimedNonRepNFTCtrlTool(const DesProject& currentProject, int N, QWidget* parent = 0);
		inline bool isTimedNonRepFaultsControllable() {return m_isTimedNonRepFaultsControllable;}

		void runNonRepNFTNonBlockTool(const DesProject& currentProject, int N, QWidget* parent = 0);
		inline bool isnonRepFaultsNonblocking() {return m_isnonRepFaultsNonblocking;}

		//for resettable FT Algo
		void runResettableFTCtrlTool(const DesProject& currentProject);
		inline bool isResetFaultsControllable(){return m_isResetFaultsControllable;}

		void runTimedResettableFTCtrlTool(const DesProject& currentProject);
		inline bool isTimedResetFaultsControllable() {return m_isTimedResetFaultsControllable;}

		void runResettableFTNonBlockTool(const DesProject& currentProject);
		inline bool isResetFaultsNonblocking() {return m_isResetFaultsNonblocking;}

		//for BDD FT Ctrl.
		BDDSD::SD_CtrlChkInfo runBDDDFTCtrlTool(const DesProject& currentProject, QWidget* parent);
		BDDSD::SD_TCtrlChkInfo runTimedBDDDFTCtrlTool(const DesProject& currentProject, QWidget* parent);
		BDDSD::SD_CtrlChkInfo runBDDNFTCtrlTool(const DesProject& currentProject, int N, QWidget* parent);
		BDDSD::SD_TCtrlChkInfo runTimedBDDNFTCtrlTool(const DesProject& currentProject, int N, QWidget* parent);
		BDDSD::SD_CtrlChkInfo runBDDNonRepNFTCtrlTool(const DesProject& currentProject, int N, QWidget* parent);
		BDDSD::SD_TCtrlChkInfo runTimedBDDNonRepNFTCtrlTool(const DesProject& currentProject, int N, QWidget* parent);
		BDDSD::SD_CtrlChkInfo runBDDResettableFTCtrlTool(const DesProject& currentProject);
		BDDSD::SD_TCtrlChkInfo runTimedBDDResettableFTCtrlTool(const DesProject& currentProject);

		//for BDD FT Nonblocking
		BDDSD::SD_NBChkInfo runBDDDFTNonblockingTool(const DesProject& currentProject, QWidget* parent);
		BDDSD::SD_NBChkInfo runBDDNFTNonblockingTool(const DesProject& currentProject, int N, QWidget* parent);
		BDDSD::SD_NBChkInfo runBDDNonRepNFTNonblockingTool(const DesProject& currentProject, int N, QWidget* parent);
		BDDSD::SD_NBChkInfo runBDDResettableFTNonblockingTool(const DesProject& currentProject);

	private:
		QList<QString> m_nonFaultSet;
		QList<QString> m_DFaultSet;
		QMultiMap<int, QString> m_faultSets;
		QMultiMap<int, QString> m_resetableSets;

		bool m_isDFTControllable;
		bool m_isTimedDFTControllable;
		bool m_isDFTNonblocking;

		bool m_isNFaultsControllable;
		bool m_isTimedNFaultsControllable;
		bool m_isNFaultsNonblocking;

		bool m_isnonRepFaultsControllable;
		bool m_isTimedNonRepFaultsControllable;
		bool m_isnonRepFaultsNonblocking;

		bool m_isResetFaultsControllable;
		bool m_isTimedResetFaultsControllable;
		bool m_isResetFaultsNonblocking;

	};
}
