/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QObject>
#include <QMenu>
#include "ui_GedDesEditor.h"
#include "DesState.h"
#include "DesNotifications.h"

class QGroupBox;
class QTreeWidget;

namespace DESpot
{
	class DespotTreeWidget;
	class GedDesWorkspace;
	class Des;
	class GedStateQuickLookUiPart;
	class TransRecorder;

	class GedStateEditorUiPart : public QObject, private DesNotifications
	{
		Q_OBJECT	

		public:
			GedStateEditorUiPart(GedDesWorkspace* pWorkspace, Ui::GedDesEditorUI* pUiContainer, 
							  Des* pDes, GedStateQuickLookUiPart* pGedStateQuickLookUiPart, 
							  TransRecorder& transRecorder);
			virtual ~GedStateEditorUiPart(void);

		public:
			void clearSelection();
			
			//returns the context menu for this UI Part
			QMenu& getContextMenu();

			StateViewerWidget* getStateViewerWidget()
			{ return m_pStateViewWidg;}

		//Signals_______________________________________
		signals:
			void onCurrentStateChanged(const DesState& selectedState);

		//Slots_________________________________________
		private slots:			
			void onUserChangedStateName(const DesState& changedState, const std::wstring& newName);
			void onUserChangedStateAlias(const DesState& changedState, const std::wstring& newAlias);
			void onUserChangedStateInit(const DesState& changedState, bool newInit);
			void onUserChangedStateMarking(const DesState& changedState, bool newMarking);
			
		//Des Notification Handlers_______________________
		private:
			virtual void onReachabilityChanged();
			
			//Notifications received from the contained DES when the its states change
			virtual void onStateAdded(const DesState& addedState);
			virtual void onStateChanged(const DesState& changedState);
			virtual void onRemovingState(const DesState& state);

		//Implementation Methods________________________
		private:
			void initStateViewWidget();
			void setupConnections(GedDesWorkspace* pWorkspace);

		signals:
			void itemClicked(QTreeWidgetItem*, int);

		private slots:
			void onStateItemClicked ( QTreeWidgetItem * item, int column );

		private:
			StateViewerWidget* m_pStateViewWidg;

			QMenu m_stateEditorContextMenu;

			//The Des that owns the state displayed in this UI part
			Des* m_pDes;
			unsigned int m_desListnerId;

			GedStateQuickLookUiPart* m_pGedStateQuickLookUiPart;
};

} //end of namespace DESpot
