/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2015
*/

#pragma once
#include <iostream>
#include "NonRepFTAlgoNonBlock.h"
#include "FlatProjIntegrityAlgo.h"
#include "MultiNonBlockingAlgo.h"

namespace DESpot

{
NonRepFTAlgoNonBlock::NonRepFTAlgoNonBlock(const DesProject& currentProject, QList<QString>& faultSet ,int M , int N , QMultiMap<int, QString>& faultSets):NonRepFTAlgo(currentProject,faultSet,M,N,faultSets),m_isnonRepFaultsNonblocking(false)
{
}
//____________________________________________________________________________________________________________________________________	
NonRepFTAlgoNonBlock::~NonRepFTAlgoNonBlock()
{
}
//____________________________________________________________________________________________________________________________________

bool NonRepFTAlgoNonBlock::runAlgo()
{
	DefaultFTAlgo::createDummyFlatProject();
	if (! m_faultSet.isEmpty())
	{	
		DefaultFTAlgo::constructGF();
		DefaultFTAlgo::addGF();
	}
	if (m_N < m_M)
	{
		NonRepFTAlgo::constructGNF();
		NonRepFTAlgo::addGNF();
	}
	if (m_N > 0)
	{
		NonRepFTAlgo::constructGFi();
	}
	return NonRepFTAlgoNonBlock::verifyFTNonBlock();

}
//____________________________________________________________________________________________________________________________________
bool NonRepFTAlgoNonBlock::verifyFTNonBlock()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		MultiNonBlockingAlgo flatNonBlock;
		DesSubsystem::DesIteratorPtr hDesIt = m_flatDummyProject->createDesIterator();
		for(hDesIt->first(); hDesIt->notDone(); hDesIt->next())
		{
			const Des& hDes = hDesIt->currentItem();
			flatNonBlock.addInputDes(&hDes);
		}
		m_isnonRepFaultsNonblocking = (m_flatDummyProject->checkNonBlocking(flatNonBlock));

		return (m_isnonRepFaultsNonblocking);
	}
	else
	{throw EX("Project Integrity test has failed");}
}
//____________________________________________________________________________________________________________________________________
bool NonRepFTAlgoNonBlock::isnonRepFaultsNonblocking() const
{
	return m_isnonRepFaultsNonblocking;
}
//____________________________________________________________________________________________________________________________________
}


