/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2016
*/
#pragma once
#include <iostream>
#include "BDDNFaultsAlgoNonblocking.h"
#include "Des.h"
#include "DesProject.h"
#include "FlatDummyProject.h"
#include "FlatProjIntegrityAlgo.h"
#include "BddSdMain.h"


namespace DESpot

{
BDDNFaultsAlgoNonblocking::BDDNFaultsAlgoNonblocking(const DesProject& currentProject, QList<QString>& faultSet, int N , QMultiMap<int,QString>& faultSets): NFaultsAlgo(currentProject, faultSet, N, faultSets), m_isBDDNFaultsNonblocking(false)
{
	GNFDes = NULL;
}
//____________________________________________________________________________________________________________________________________	
BDDNFaultsAlgoNonblocking::~BDDNFaultsAlgoNonblocking()
{
}
//____________________________________________________________________________________________________________________________________

BDDSD::SD_NBChkInfo BDDNFaultsAlgoNonblocking::runBDDFTNonblockingAlgo()
{
	DefaultFTAlgo::createDummyFlatProject();
	if (! m_faultSet.isEmpty())
	{
		DefaultFTAlgo::constructGF();	
		DefaultFTAlgo::addGF();
	}
	int m = m_faultSets.uniqueKeys().size();
	if (m_N < m)
	{
		NFaultsAlgo::constructGNF();
		NFaultsAlgo::addGNF();
	}	
	return BDDNFaultsAlgoNonblocking::verifyBDDFTNonblocking();
}
//____________________________________________________________________________________________________________________________________
BDDSD::SD_NBChkInfo BDDNFaultsAlgoNonblocking::verifyBDDFTNonblocking()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		int tmp;
		BDDSD::SD_NBChkInfo  checkInfo("Project passes Nonblocking Check");
      		tmp = BddSdCheckNB((DesProject&) *m_flatDummyProject, checkInfo);
     		if (checkInfo.m_chkPassed)
			m_isBDDNFaultsNonblocking = true;
		else
			m_isBDDNFaultsNonblocking = false;
		return checkInfo;
	}
	else
	{throw EX("Project Integrity test has failed");}

}
//____________________________________________________________________________________________________________________________________
bool BDDNFaultsAlgoNonblocking::isBDDNFaultsNonblocking() const
{return m_isBDDNFaultsNonblocking;}
}


