#pragma once

/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include "DesAlgo.h"

namespace DESpot
{
	class ControllabilityAlgo : virtual public DesAlgo
	{
		public:	
			//Returns true if the supervisor DES is controllable for the plant DES
			bool isControllable() const
			{
				return m_isControllable;
			}

			void overrideControllable(bool isControllable)
			{
				m_isControllable = isControllable;
			}

			bool isTControllable() const
			{
				return m_isTControllable;
			}

			void overrideTControllable(bool isTControllable)
			{
				m_isTControllable = isTControllable;
			}
		protected:
			//true if the supervisor DES is controllable for the plant DES
			bool m_isControllable;
			bool m_isTControllable;

		protected:
			//this is just a base class (interface). It is not meant to instantiate objects off of it
			ControllabilityAlgo(void) : m_isControllable(false) , m_isTControllable(false)  {}
			virtual ~ControllabilityAlgo(void){}
	};
}
