#include <QHeaderView>
#include <QMessageBox>
#include <QResizeEvent>

#include "DecEventViewerWidget.h"
#include "Des.h"
#include "DecObserver.h"

namespace DESpot
{
    const int DecEventViewerWidget::cColCount = 1;
    const int DecEventViewerWidget::cEventNameColIdx = 0;
    const QString DecEventViewerWidget::cEventNameColName = "Name";

    DecEventViewerWidget::DecEventViewerWidget(QWidget* parent): DespotTreeWidget(parent)
    {
    }

    DecEventViewerWidget::~DecEventViewerWidget(void)
    {
    }

    void DecEventViewerWidget::setAllowEdit(bool allowEdit)
    {
        m_allowEdit = allowEdit;
    }

    void DecEventViewerWidget::initWidget()
    {
        setColumnCount(getColumnCount());
        QStringList headers;
        getHeaders(headers);
        setHeaderLabels(headers);
        headerItem()->setTextAlignment(cEventNameColIdx, Qt::AlignLeft);
        header()->setSortIndicatorShown(false);
    }

    int DecEventViewerWidget::getColumnCount()
    {
        return cColCount;
    }

    void DecEventViewerWidget::getHeaders(QStringList &out_headerList)
    {
        out_headerList << cEventNameColName;
    }

    QTreeWidgetItem* DecEventViewerWidget::createUiItemFromEvent(const DesEvent &event)
    {
        QTreeWidgetItem* pEventUiItem = new QTreeWidgetItem();
        pEventUiItem->setTextAlignment(cEventNameColIdx, Qt::AlignLeft);

        fillEventUiItemObs(*pEventUiItem, event);
        fillEventUiItemCtrl(*pEventUiItem, event);

        return pEventUiItem;
    }

    void DecEventViewerWidget::fillEventUiItemObs(QTreeWidgetItem& eventUiItem, const DesEvent &desEvent)
    {
        QString eventName = QString::fromStdWString(desEvent.getName());
        if(eventName != eventUiItem.text(cEventNameColIdx))
        {
            eventUiItem.setText(cEventNameColIdx,eventName);
        }
    }

    void DecEventViewerWidget::fillEventUiItemCtrl(QTreeWidgetItem& eventUiItem, const DesEvent &desEvent)
    {
        QString eventName = QString::fromStdWString(desEvent.getName());
        if(eventName != eventUiItem.text(cEventNameColIdx))
        {
            if(desEvent.isControllable())
            {
                eventUiItem.setText(cEventNameColIdx,eventName);
            }
        }
    }

    bool DESpot::DecEventViewerWidget::isEventUiItem(QTreeWidgetItem &item)
    {
        DesEvent* pEvent = reinterpret_cast<DesEvent*>(item.data(0,Qt::UserRole).toULongLong());
        return (pEvent != null);
    }

    const DesEvent& DecEventViewerWidget::getEventFromUiItem(QTreeWidgetItem &eventUiItem)
    {
        DesEvent* pEvent = reinterpret_cast<DesEvent*>(eventUiItem.data(0, Qt::UserRole).toULongLong());
        assert (pEvent != null);
        return *pEvent;
    }
}
