#pragma once

#include "DespotTreeWidget.h"
#include "DesEvent.h"

namespace DESpot
{
    class DecObserver;
    class Des;

    class DecEventViewerWidget :public DespotTreeWidget
    {
        Q_OBJECT

    public:
        DecEventViewerWidget(QWidget* parent = 0);
        virtual ~DecEventViewerWidget(void);

    public:
        void setAllowEdit(bool allowEdit = true);
        virtual void initWidget();

    protected:
        QTreeWidgetItem* createUiItemFromEvent(const DesEvent& event);
        virtual void fillEventUiItemObs(QTreeWidgetItem& eventUiItem, const DesEvent& desEvent);
        virtual void fillEventUiItemCtrl(QTreeWidgetItem& eventUiItem, const DesEvent& desEvent);
        virtual int getColumnCount();
        virtual void getHeaders(QStringList& out_headerList);

        bool isEventUiItem(QTreeWidgetItem& item);
        const DesEvent& getEventFromUiItem(QTreeWidgetItem& eventUiItem);

    protected:
        static const int cColCount;
        static const int cEventNameColIdx;
        static const QString cEventNameColName;

    protected:
        bool m_allowEdit;

    };
}
