#pragma once

#include <QDialog>
#include <QMap>
#include <QMessageBox>
#include <QComboBox>

#include "DesSubsystem.h"
#include "ProjectEditor.h"
#include "DesNotifications.h"
#include "DecObserver.h"
#include "DesProject.h"
#include "DesInterface.h"
#include "DesTypes.h"
#include "DesEvent.h"
#include "ProjectEvent.h"
#include "ProjectWorkspace.h"
#include "DecentralizedEventEditorUi.h"
#include "ui_DecentralizedEventEditor.h"

namespace DESpot
{
    class MainForm;
    class ProjectEditor;
    class DecentralizedEventEditorUi;
    class Des;
    class DesEvent;
    class DesProject;
    class ProjectEditor;
    class ProjectWorkspace;
    class DecObserver;
    class DesSubsystem;

    class DecentralizedEventEditor: public QDialog, public Ui::DecentralizedEventEdUI
    {
        Q_OBJECT

	    public:
	    	DecentralizedEventEditor(MainForm* pMainForm, ProjectEditor* projEditorOwner);
	    	virtual ~DecentralizedEventEditor(void);

	    public:
	        ProjectEditor* projEditorOwner();

	    private:
	        DecentralizedEventEditorUi* m_uiPart;
    };
}
