/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2015
*/

#pragma once
//#include <iostream>
#include "DefaultFTAlgoNonBlock.h"
#include "FlatProjIntegrityAlgo.h"
#include "MultiNonBlockingAlgo.h"

namespace DESpot

{
DefaultFTAlgoNonBlock::DefaultFTAlgoNonBlock(const DesProject& currentProject, QList<QString>& faultSet): 
DefaultFTAlgo(currentProject,faultSet),m_isDFTNonblocking(false)
{
}
//____________________________________________________________________________________________________________________________________	
DefaultFTAlgoNonBlock::~DefaultFTAlgoNonBlock()
{
}
//____________________________________________________________________________________________________________________________________
bool DefaultFTAlgoNonBlock::runAlgo()
{

	// check that excluded fault set is valid
	if (! (m_currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	} 

	if (! m_faultSet.isEmpty())	
	{
		DefaultFTAlgo::createDummyFlatProject();
		DefaultFTAlgo::constructGF();
		DefaultFTAlgo::addGF();
		return DefaultFTAlgoNonBlock::verifyFTNonBlocking();
	}
	else
	{throw EX("There are no excluded fault events. Please run the standard nonblocking algorithm.");}

	return false;

}
//____________________________________________________________________________________________________________________________________
bool DefaultFTAlgoNonBlock::verifyFTNonBlocking()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		MultiNonBlockingAlgo flatNonBlock;
		DesSubsystem::DesIteratorPtr hDesIt = m_flatDummyProject->createDesIterator();
		for(hDesIt->first(); hDesIt->notDone(); hDesIt->next())
		{
			const Des& hDes = hDesIt->currentItem();
			flatNonBlock.addInputDes(&hDes);
		}
		m_isDFTNonblocking = (m_flatDummyProject->checkNonBlocking(flatNonBlock));
		return m_isDFTNonblocking;
	}
	else
	{
		throw EX("Project Integrity test has failed");
	}

	return m_isDFTNonblocking;
}
//____________________________________________________________________________________________________________________________________
bool DefaultFTAlgoNonBlock::isDFTNonBlocking() const
{
	return m_isDFTNonblocking;
}
//____________________________________________________________________________________________________________________________________
}
