/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2015
*/

#include <iostream>
#include "FaultListsDlg.h"

namespace DESpot
{
FaultListsDlg::FaultListsDlg(DesProject& currentProject, QList<QString>& currentnonFaultSet, QList<QString>& DFaultSet, QMultiMap<int, QString>& currentFaultSets, QMultiMap<int, QString>& currentResetableSets, QWidget* parent /*= null*/): m_currentProject(currentProject), m_nonFaultSet(currentnonFaultSet), m_DFaultSet(DFaultSet), m_faultSets(currentFaultSets), m_resetSets(currentResetableSets), QWizard(parent)
{
	setupUi(this);
	I = m_faultSets.uniqueKeys().size();
	origNumKeys = I;

	if (I > 0)
	{
		spinBox->setValue(I);
		key = I-(I-1);
	}
	else {
	   spinBox->setValue(1);
	}

	pageCount = 1;
	listProjectEvents();
	finish = false;
	finalPage->setFinalPage(true);
}
//_________________________________________________________________________________________________
FaultListsDlg::~FaultListsDlg(void)
{
}
//_________________________________________________________________________________________________
void FaultListsDlg::listProjectEvents()
{

	DesProject::EventIteratorPtr eventIt = 
              m_currentProject.createProjEventIterator();
	m_nonFaultSet.clear();

	for(eventIt->first(); eventIt->isDone() == false; eventIt->next())
	{
		const DesEvent& event = eventIt->currentItem();

		QString eventName = QString::fromStdWString(event.getName());

		if (!m_DFaultSet.contains(eventName)) {
		  m_nonFaultSet.append(eventName);
		}
	}


	if (! m_nonFaultSet.isEmpty())
	{
		for(int i=0 ; i < m_nonFaultSet.size(); i++)
			{new QListWidgetItem(m_nonFaultSet.at(i),ProjectEventsQListWidget);}
	}
	else
	{
		QMessageBox msgBox;
		msgBox.setText("No possible fault events");
		msgBox.setIcon(QMessageBox::Critical);
		msgBox.exec();
	}

}	
//_________________________________________________________________________________________________
void FaultListsDlg::onAddFFaults()
{
	QListWidgetItem *item = ProjectEventsQListWidget->currentItem();
	if (item)
	{
		QString eventName = ProjectEventsQListWidget->item(ProjectEventsQListWidget->currentRow())->text();
		ProjectEventsQListWidget->takeItem(ProjectEventsQListWidget->currentRow());
		FualtSetQListWidget->addItem(item);
		if ((m_nonFaultSet.contains(eventName)))
		{
			m_nonFaultSet.removeOne(eventName);
		}
	}
	ProjectEventsQListWidget->update();
	FualtSetQListWidget->update();
	modifiedF = true;
	validF = false;
}
//_________________________________________________________________________________________________
void FaultListsDlg::onRemoveFFaults()
{
	QListWidgetItem *item = FualtSetQListWidget->currentItem();
	if (item)
	{
		QString eventName = FualtSetQListWidget->item(FualtSetQListWidget->currentRow())->text();
		FualtSetQListWidget->takeItem(FualtSetQListWidget->currentRow());
		ProjectEventsQListWidget->addItem(item);
		if ((m_faultSets.contains(key, eventName)))
		{
			m_faultSets.remove(key, eventName);
		}
	}
	ProjectEventsQListWidget->update();
	FualtSetQListWidget->update();
	modifiedF = true;
}
//_________________________________________________________________________________________________
void FaultListsDlg::onAddTFaults()
{
	QListWidgetItem *item = ProjectEventsQListWidget->currentItem();
	if (item)
	{
		QString eventName = ProjectEventsQListWidget->item(ProjectEventsQListWidget->currentRow())->text();
		ProjectEventsQListWidget->takeItem(ProjectEventsQListWidget->currentRow());
		ResetableSetQListWidget->addItem(item);
		if ((m_nonFaultSet.contains(eventName)))
		{
			m_nonFaultSet.removeOne(eventName);
		}

	}
	ProjectEventsQListWidget->update();
	ResetableSetQListWidget->update();
	modifiedT = true;
}
//_________________________________________________________________________________________________
void FaultListsDlg::onRemoveTFaults()
{
	QListWidgetItem *item = ResetableSetQListWidget->currentItem();
	if (item)
	{
		QString eventName = ResetableSetQListWidget->item(ResetableSetQListWidget->currentRow())->text();
		ResetableSetQListWidget->takeItem(ResetableSetQListWidget->currentRow());
		ProjectEventsQListWidget->addItem(item);
		if ((m_resetSets.contains(key, eventName)))
		{
			m_resetSets.remove(key, eventName);
		}
	}
	ProjectEventsQListWidget->update();
	ResetableSetQListWidget->update();
	modifiedT = true;
}
//_________________________________________________________________________________________________
int FaultListsDlg::getI()
{return I;}
//_________________________________________________________________________________________________
int FaultListsDlg::nextId() const
{	if (! finish)
		return pageCount;
	if (currentId() == 1)
		return -1;
	return 1;
}
//_________________________________________________________________________________________________
bool FaultListsDlg::validateCurrentPage()
{
	(this->currentPage())-> setCommitPage(true);
	if (currentId() == startId())
	{

		I = spinBox->value();
		if ( I == 0) {
		   QString message("You have specified zero fault/reset sets.  Do you wish to remove all non-excluded fault and reset sets from the project?");
		   bool remvFaults = (QMessageBox::question(this, "DESpot", message, QMessageBox::Yes | QMessageBox::No) == QMessageBox::Yes);

		    if (remvFaults) {
				
			m_faultSets.clear();
			m_resetSets.clear();
			m_currentProject.setFaultSets(m_faultSets);
			m_currentProject.setResetSets(m_resetSets);

		        m_nonFaultSet.clear();
			for(int i=0; i< ProjectEventsQListWidget->count(); i++) 
			{	
			   QString eventName = ProjectEventsQListWidget->item(i)->text();
			   m_nonFaultSet.append(eventName);
			}
			
		        m_currentProject.setNonFaultSet(m_nonFaultSet);
			m_currentProject.setFaultSetsValid(false);
		    }

		    finish = true;
		    return QWizard::validateCurrentPage();

		}


		key = I-(I-1);  
		pageCount++;
		addNewFaultSetPage();
		return QWizard::validateCurrentPage();
	}
	else if (currentId() != 1) 
	{
		if ((FualtSetQListWidget->count()==0))
		{
			QMessageBox msgBox;
			msgBox.setText("Fault event set should not be empty");
			msgBox.setIcon(QMessageBox::Critical);
			msgBox.exec();
			return false;
		}
		else
		{
			if (FaultListsDlg::onValidateFaults())	
			{	
				for(int i=0; i< FualtSetQListWidget->count(); i++)
				{
					QString eventName = FualtSetQListWidget->item(i)->text();
					if (! (m_faultSets.contains(key, eventName)))
					{
						m_faultSets.insert(key, eventName);
					}
				}
				
				for(int i=0; i< ResetableSetQListWidget->count(); i++)
				{
					QString eventName = ResetableSetQListWidget->item(i)->text();
					if (! (m_resetSets.contains(key, eventName)))
					{
						m_resetSets.insert(key, eventName);
					}
				}
				m_currentProject.setFaultSets(m_faultSets);
				m_currentProject.setResetSets(m_resetSets);

				key++;
				if (pageCount <= I)
				{
					pageCount++;
					addNewFaultSetPage();
				}
				else
				{	
					finish = true;
					m_nonFaultSet.clear();
					for(int i=0; i< ProjectEventsQListWidget->count(); i++)
					{	
						QString eventName = ProjectEventsQListWidget->item(i)->text();
						m_nonFaultSet.append(eventName);
					}
					m_currentProject.setNonFaultSet(m_nonFaultSet);

					while (key <= origNumKeys) {
					     int junk1 = m_faultSets.remove(key);
				 	     int junk2 = m_resetSets.remove(key);
					     key++;
					}

				
					m_currentProject.setFaultSets(m_faultSets);
					m_currentProject.setResetSets(m_resetSets);
					m_currentProject.setFaultSetsValid(true);
				}
				return QWizard::validateCurrentPage();
			}
			else {
			   return false; 
			}
		}
	}
	else
		return QWizard::validateCurrentPage();

}
//_________________________________________________________________________________________________
bool FaultListsDlg::onValidateFaults()
{			
	if (! validF && (currentId() != startId())) 
	{	
		for(int i=0; i< FualtSetQListWidget->count(); i++)
		{	
			QString eventName = FualtSetQListWidget->item(i)->text();

			DesProject::EventIteratorPtr eventIt =  m_currentProject.createProjEventIterator();
			for(eventIt->first(); eventIt->isDone() == false; eventIt->next())
			{
				const DesEvent& event = eventIt->currentItem();
				QString currentEventName = QString::fromStdWString(event.getName());
				if (currentEventName == eventName)
				{
					if (event.isControllable())
					{
						QMessageBox msgBox;
						msgBox.setText("Fault events should not be a controllable event");
						msgBox.setIcon(QMessageBox::Critical);
						msgBox.exec();
						return validF;
					}
				}
			}


			const DesEvent* event;
			DesProject::DesIteratorPtr supIt = m_currentProject.createDesIterator(eSupervisorDes);
			for(supIt->first(); supIt->isDone() == false; supIt->next())
			{	
				const Des& supDes = supIt->currentItem();
				if (supDes.findEvent(eventName.toStdWString(),event))
				{
					QMessageBox msgBox;
					msgBox.setText("Fault events should not belong to a supervisor");
					msgBox.setIcon(QMessageBox::Critical);
					msgBox.exec();
					return validF;
				}
			}		
		}
		
	}

if (!(pageCount <= I)) {
   QMessageBox msgBox;
   msgBox.setText("Fault events are valid");
   msgBox.setIcon(QMessageBox::Information);
   msgBox.exec();
}

validF = true;
return validF;	
}
//_________________________________________________________________________________________________
void FaultListsDlg::addNewFaultSetPage() 
{
        wizardPage = new QWizardPage();
        wizardPage->setObjectName(QString::fromUtf8("wizardPage"));

	groupBox_4 = new QGroupBox(wizardPage);
        groupBox_4->setObjectName(QString::fromUtf8("groupBox_4"));
        groupBox_4->setGeometry(QRect(0, 50, 282, 361));
        gridLayout_4 = new QGridLayout(groupBox_4);
        gridLayout_4->setObjectName(QString::fromUtf8("gridLayout_4"));
        gridLayout_4->addWidget(ProjectEventsQListWidget, 0, 0, 1, 1);

        RemoveTFaultsButton = new QPushButton(wizardPage);
        RemoveTFaultsButton->setObjectName(QString::fromUtf8("RemoveTFaultsButton"));
        RemoveTFaultsButton->setGeometry(QRect(291, 330, 85, 31));
        AddFFaultsButton = new QPushButton(wizardPage);
        AddFFaultsButton->setObjectName(QString::fromUtf8("AddMFaults"));
        AddFFaultsButton->setGeometry(QRect(291, 93, 85, 31));
	ValidateButton = new QPushButton(wizardPage);
        ValidateButton->setObjectName(QString::fromUtf8("ValidateButton"));
        ValidateButton->setGeometry(QRect(291, 170, 85, 31));
        label_4 = new QLabel(wizardPage);
        label_4->setObjectName(QString::fromUtf8("label_4"));
        label_4->setGeometry(QRect(20, 10, 311, 21));
        label_4->setFocusPolicy(Qt::NoFocus);
        groupBox_3 = new QGroupBox(wizardPage);
        groupBox_3->setObjectName(QString::fromUtf8("groupBox_3"));
        groupBox_3->setGeometry(QRect(390, 50, 280, 180));
        gridLayout_3 = new QGridLayout(groupBox_3);
        gridLayout_3->setObjectName(QString::fromUtf8("gridLayout_3"));
        FualtSetQListWidget = new QListWidget(groupBox_3);
        FualtSetQListWidget->setObjectName(QString::fromUtf8("FualtSetQListWidget"));
        gridLayout_3->addWidget(FualtSetQListWidget, 0, 0, 1, 1);
        RemoveFFaultsButton = new QPushButton(wizardPage);
        RemoveFFaultsButton->setObjectName(QString::fromUtf8("RemoveFFaultsButton"));
        RemoveFFaultsButton->setGeometry(QRect(291, 130, 85, 31));
        AddTFaultsButton = new QPushButton(wizardPage);
        AddTFaultsButton->setObjectName(QString::fromUtf8("AddTFaultsButton"));
        AddTFaultsButton->setGeometry(QRect(291, 293, 85, 31));
        groupBox_5 = new QGroupBox(wizardPage);
        groupBox_5->setObjectName(QString::fromUtf8("groupBox_5"));
        groupBox_5->setGeometry(QRect(390, 250, 280, 181));
        gridLayout_5 = new QGridLayout(groupBox_5);
        gridLayout_5->setObjectName(QString::fromUtf8("gridLayout_5"));
        ResetableSetQListWidget = new QListWidget(groupBox_5);
        ResetableSetQListWidget->setObjectName(QString::fromUtf8("ResetableSetQListWidget"));
        gridLayout_5->addWidget(ResetableSetQListWidget, 0, 0, 1, 1);


        this->setPage(pageCount,wizardPage);

	const char *str = "Fault Sets: ";
 	stringstream sstm;
 	sstm << str << key;
 	string ans = sstm.str();
 	const char * text = (char *) ans.c_str();

        RemoveTFaultsButton->setText(QApplication::translate("ResetFT", "Remove"));
        AddFFaultsButton->setText(QApplication::translate("ResetFT", "Add"));
        label_4->setText(QApplication::translate("ResetFT", text ));
        groupBox_3->setTitle(QApplication::translate("ResetFT", "Fi Fault Events"));
        RemoveFFaultsButton->setText(QApplication::translate("ResetFT", "Remove"));
        groupBox_4->setTitle(QApplication::translate("ResetFT", "Project Events"));
        AddTFaultsButton->setText(QApplication::translate("ResetFT", "Add"));
        groupBox_5->setTitle(QApplication::translate("ResetFT", "Ti Reset Events"));
	ValidateButton->setText(QApplication::translate("ResetFT", "Validate"));


	connect(AddFFaultsButton, SIGNAL(clicked()), this,SLOT(onAddFFaults()));
	connect(RemoveFFaultsButton, SIGNAL(clicked()), this,SLOT(onRemoveFFaults()));
	connect(ValidateButton, SIGNAL(clicked()), this,SLOT(onValidateFaults()));
	connect(AddTFaultsButton, SIGNAL(clicked()), this,SLOT(onAddTFaults()));
	connect(RemoveTFaultsButton, SIGNAL(clicked()), this,SLOT(onRemoveTFaults()));

	if (! m_faultSets.isEmpty())  {
		QList<QString> values = m_faultSets.values((key));
		for (int i=0 ; i< values.size() ; i++)  {
                   QString fltEventName =  values.at(i);
                   bool eventFound = false;
                   int fndItem  = 0;

		   for(int i=0; i< ProjectEventsQListWidget->count(); i++)  {	
			QString eventName = ProjectEventsQListWidget->item(i)->text();
			fndItem = i;
		        if (eventName == fltEventName){
		          eventFound = true;
                          break;
		        }
		   }
			
		   //  only want to add event if it is still in project list
		   if (eventFound)  {
		     ProjectEventsQListWidget->setCurrentItem(ProjectEventsQListWidget->item(fndItem));
		     FaultListsDlg::onAddFFaults();
                  }
	        }
	}

	if (! m_resetSets.isEmpty())  {
		QList<QString> values = m_resetSets.values((key));
		for (int i=0 ; i < values.size() ; i++)  {
                   QString fltEventName =  values.at(i);
                   bool eventFound = false;
                   int fndItem  = 0;

		   for(int i=0; i< ProjectEventsQListWidget->count(); i++)  {	
			QString eventName = ProjectEventsQListWidget->item(i)->text();
			fndItem = i;
		        if (eventName == fltEventName){
		          eventFound = true;
                          break;
		        }
		   }
			
   		   //  only want to add event if it is still in project list
		   if (eventFound)  {
		      ProjectEventsQListWidget->setCurrentItem(ProjectEventsQListWidget->item(fndItem));
		      FaultListsDlg::onAddTFaults();
                   }
	        }
	}

}
//_________________________________________________________________________________________________

} // end of namespace DESpot
