/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2015	
*/
#pragma once
#include <iostream>
#include "FaultTolerant.h"
#include "DefaultFTDlg.h"
#include "DefaultFTAlgo.h"
#include "DefaultFTAlgoTimed.h"
#include "DefaultFTAlgoNonBlock.h"
#include "NFaultsAlgo.h"
#include "NFaultsAlgoTimed.h"
#include "NFaultsAlgoNonBlock.h"
#include "NonRepFTAlgo.h"
#include "NonRepFTAlgoTimed.h"
#include "NonRepFTAlgoNonBlock.h"
#include "FaultListsDlg.h"
#include "ResetFTAlgo.h"
#include "ResetFTAlgoTimed.h"
#include "ResetFTAlgoNonBlock.h"
#include "BDDDefaultFTAlgo.h"
#include "BDDDefaultFTAlgoTimed.h"
#include "BDDNFaultsAlgo.h"
#include "BDDNFaultsAlgoTimed.h"
#include "BDDNonRepFTAlgo.h"
#include "BDDNonRepFTAlgoTimed.h"
#include "BDDResetFTAlgo.h"
#include "BDDResetFTAlgoTimed.h"
#include "BDDDefaultFTAlgoNonblocking.h"
#include "BDDNFaultsAlgoNonblocking.h"
#include "BDDNonRepFTAlgoNonblocking.h"
#include "BDDResetFTAlgoNonblocking.h"
#include <QObject>
#include <QMessageBox>

namespace DESpot
{

FaultTolerant::FaultTolerant()
{
}
//___________________________________________________________________________________________________________________________________________________
FaultTolerant::~FaultTolerant()
{
}
//___________________________________________________________________________________________________________________________________________________
void FaultTolerant::setNonFaultSet(DesProject& currentProject)
{
	m_nonFaultSet = currentProject.getNonFaultSet();
	m_DFaultSet = currentProject.getDFaultSet();
	m_faultSets = currentProject.getFaultSets();
	m_resetableSets = currentProject.getResetSets();

	if ((m_nonFaultSet.isEmpty()) && (m_DFaultSet.isEmpty()) && (m_faultSets.isEmpty()) && (m_resetableSets.isEmpty()))
	{
		DesProject::EventIteratorPtr eventIt = currentProject.createProjEventIterator();
		for(eventIt->first(); eventIt->isDone() == false; eventIt->next())
		{
			const DesEvent& event = eventIt->currentItem();
			QString eventName = QString::fromStdWString(event.getName());
			m_nonFaultSet.append(eventName);
		}
		currentProject.setNonFaultSet(m_nonFaultSet);
	}
	if (m_nonFaultSet.isEmpty())
	{
		QMessageBox msgBox;
		msgBox.setText("No possible fault events");
		msgBox.setIcon(QMessageBox::Critical);
		msgBox.exec();
	}

		
}/*&& (m_faultSets.isEmpty())*/
//___________________________________________________________________________________________________________________________________________________
void FaultTolerant::setDFaultSet(DesProject& currentProject, QWidget* parent)
{
	DefaultFTDlg *dftDlg = new DefaultFTDlg(currentProject, m_nonFaultSet , m_DFaultSet, parent);
	dftDlg->open();

}
//___________________________________________________________________________________________________________________________________________________
void FaultTolerant::setFaultSets(DesProject& currentProject , QWidget* parent)
{

	// Excluded fault sets must be valid before using this dialog
	if (! (currentProject.isExcldEvntsValid()) )  {
	   QMessageBox msgBox;
	   msgBox.setText("Excluded fault set not valid. Please run excluded fault set dialog before running fault and reset sets dialog.");
	   msgBox.setIcon(QMessageBox::Critical);
	   msgBox.exec();
	   return;
	} 



	FaultListsDlg *faultListsDlg = new FaultListsDlg(currentProject, m_nonFaultSet, m_DFaultSet, m_faultSets, m_resetableSets, parent);
	faultListsDlg->open();
}
//___________________________________________________________________________________________________________________________________________________
const QList<QString>& FaultTolerant::getNonFaultSet()
{
	return m_nonFaultSet;	
}
//___________________________________________________________________________________________________________________________________________________
const QList<QString>& FaultTolerant::getDFaultSet()
{
	return m_DFaultSet;
}
//___________________________________________________________________________________________________________________________________________________
const QMultiMap<int, QString>& FaultTolerant::getFaultSets()
{
	return m_faultSets;
}
//___________________________________________________________________________________________________________________________________________________
const QMultiMap<int, QString>& FaultTolerant::getResetableSets()
{
	return m_resetableSets;
}
//===================================================================================================================================================
//Default FT Algo
void FaultTolerant::runDFTCtrlTool(const DesProject& currentProject)
{
	DefaultFTAlgo defaultFTAlgo(currentProject, m_DFaultSet);
	defaultFTAlgo.provideProgress(NULL);
	m_isDFTControllable = defaultFTAlgo.runAlgo();
}
//___________________________________________________________________________________________________________________________________________________
void FaultTolerant::runTimedDFTCtrlTool(const DesProject& currentProject)
{
	DefaultFTAlgoTimed defaultFTAlgoTimed(currentProject, m_DFaultSet);
	defaultFTAlgoTimed.provideProgress(NULL);
	m_isTimedDFTControllable = defaultFTAlgoTimed.runAlgo();
}
//___________________________________________________________________________________________________________________________________________________
void FaultTolerant::runDFTNonBlockTool(const DesProject& currentProject)
{
	DefaultFTAlgoNonBlock defaultFTAlgoNonBlock(currentProject, m_DFaultSet);
	defaultFTAlgoNonBlock.provideProgress(NULL);
	m_isDFTNonblocking = defaultFTAlgoNonBlock.runAlgo();
}
//===================================================================================================================================================
//N-Faults FT Algo
void FaultTolerant::runNFTCtrlTool(const DesProject& currentProject, int N, QWidget* parent)
{

	// check that excluded fault set is valid
	if (! (currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	// check that  fault and reset sets are valid
	if (! (currentProject.isFaultSetsValid()) )  {
	   throw EX("Fault and reset sets not checked. Please run fault sets dialog.");
	}  

	if (!(m_faultSets.isEmpty()))
	{
		NFaultsAlgo nFAlgo(currentProject, m_DFaultSet , N, m_faultSets);	
		nFAlgo.provideProgress(NULL);
		m_isNFaultsControllable = nFAlgo.runAlgo();
	}
	else
	{
		throw EX("The project does not have any fault sets defined.");
	}
}
//___________________________________________________________________________________________________________________________________________________
void FaultTolerant::runTimedNFTCtrlTool(const DesProject& currentProject, int N, QWidget* parent)
{
	// check that excluded fault set is valid
	if (! (currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	// check that  fault and reset sets are valid
	if (! (currentProject.isFaultSetsValid()) )  {
	   throw EX("Fault and reset sets not checked. Please run fault sets dialog.");
	}  

	if (!(m_faultSets.isEmpty()))
	{
		NFaultsAlgoTimed nFaultsAlgoTimed(currentProject, m_DFaultSet , N, m_faultSets);
		nFaultsAlgoTimed.provideProgress(NULL);
		m_isTimedNFaultsControllable = nFaultsAlgoTimed.runAlgo();
	}
	else
	{
		throw EX("The project does not have any fault sets defined.");
	}

}
//___________________________________________________________________________________________________________________________________________________
void FaultTolerant::runNFTNonBlockTool(const DesProject& currentProject , int N, QWidget* parent)
{
	// check that excluded fault set is valid
	if (! (currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	// check that  fault and reset sets are valid
	if (! (currentProject.isFaultSetsValid()) )  {
	   throw EX("Fault and reset sets not checked. Please run fault sets dialog.");
	}  

	if (!(m_faultSets.isEmpty()))
	{
		NFaultsAlgoNonBlock nFaultsAlgoNonBlock(currentProject, m_DFaultSet , N, m_faultSets);
		nFaultsAlgoNonBlock.provideProgress(NULL);
		m_isNFaultsNonblocking = nFaultsAlgoNonBlock.runAlgo();
	}
	else
	{
		throw EX("The project does not have any fault sets defined.");
	}

}
//===================================================================================================================================================
//NonRepeatable FT Algo
void FaultTolerant::runNonRepNFTCtrlTool(const DesProject& currentProject, int N, QWidget* parent)
{
	// check that excluded fault set is valid
	if (! (currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	// check that  fault and reset sets are valid
	if (! (currentProject.isFaultSetsValid()) )  {
	   throw EX("Fault and reset sets not checked. Please run fault sets dialog.");
	}  

	int m = m_faultSets.uniqueKeys().size();

	if (!(m_faultSets.isEmpty()))
	{
		NonRepFTAlgo nonRepFTAlgo(currentProject, m_DFaultSet , m, N, m_faultSets);
		nonRepFTAlgo.provideProgress(NULL);
		m_isnonRepFaultsControllable = nonRepFTAlgo.runAlgo();
	}
	else
	{
		QMessageBox msgBox;
		msgBox.setText("The project does not have any fault sets defined.");
		msgBox.setIcon(QMessageBox::Information);
		msgBox.exec();
	}
}
//___________________________________________________________________________________________________________________________________________________
void FaultTolerant::runTimedNonRepNFTCtrlTool(const DesProject& currentProject, int N, QWidget* parent)
{
	// check that excluded fault set is valid
	if (! (currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	// check that  fault and reset sets are valid
	if (! (currentProject.isFaultSetsValid()) )  {
	   throw EX("Fault and reset sets not checked. Please run fault sets dialog.");
	}  

	int m = m_faultSets.uniqueKeys().size();

	if (!(m_faultSets.isEmpty()))
	{
		NonRepFTAlgoTimed nonRepFTAlgoTimed(currentProject, m_DFaultSet , m, N, m_faultSets);
		nonRepFTAlgoTimed.provideProgress(NULL);
		m_isTimedNonRepFaultsControllable = nonRepFTAlgoTimed.runAlgo();
	}
	else
	{
		QMessageBox msgBox;
		msgBox.setText("The project does not have any fault sets defined.");
		msgBox.setIcon(QMessageBox::Information);
		msgBox.exec();
	}

}
//___________________________________________________________________________________________________________________________________________________
void FaultTolerant::runNonRepNFTNonBlockTool(const DesProject& currentProject, int N, QWidget* parent)
{
	// check that excluded fault set is valid
	if (! (currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	// check that  fault and reset sets are valid
	if (! (currentProject.isFaultSetsValid()) )  {
	   throw EX("Fault and reset sets not checked. Please run fault sets dialog.");
	}  

	int m = m_faultSets.uniqueKeys().size();

	if (!(m_faultSets.isEmpty()))
	{
		NonRepFTAlgoNonBlock nonRepFTAlgoNonBlock(currentProject, m_DFaultSet , m, N, m_faultSets);
		nonRepFTAlgoNonBlock.provideProgress(NULL);
		m_isnonRepFaultsNonblocking = nonRepFTAlgoNonBlock.runAlgo();
	}
	else
	{
		QMessageBox msgBox;
		msgBox.setText("The project does not have any fault sets defined.");
		msgBox.setIcon(QMessageBox::Information);
		msgBox.exec();
	}
}
//===================================================================================================================================================
//Resettable FT Algo
void FaultTolerant::runResettableFTCtrlTool(const DesProject& currentProject)
{
	// check that excluded fault set is valid
	if (! (currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	// check that  fault and reset sets are valid
	if (! (currentProject.isFaultSetsValid()) )  {
	   throw EX("Fault and reset sets not checked. Please run fault sets dialog.");
	}  

	if (!(m_faultSets.isEmpty()))
	{
		int m = m_faultSets.uniqueKeys().size();
		ResetFTAlgo resetFTAlgo(currentProject, m_DFaultSet, m , m_faultSets , m_resetableSets);
		resetFTAlgo.provideProgress(NULL);
		m_isResetFaultsControllable = resetFTAlgo.runAlgo();
	}
	else
	{
		QMessageBox msgBox;
		msgBox.setText("The project does not have any fault sets defined.");
		msgBox.setIcon(QMessageBox::Information);
		msgBox.exec();
	}
}
//___________________________________________________________________________________________________________________________________________________
void FaultTolerant::runTimedResettableFTCtrlTool(const DesProject& currentProject)
{
	// check that excluded fault set is valid
	if (! (currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	// check that  fault and reset sets are valid
	if (! (currentProject.isFaultSetsValid()) )  {
	   throw EX("Fault and reset sets not checked. Please run fault sets dialog.");
	}  

	if (!(m_faultSets.isEmpty()))
	{
		int m = m_faultSets.uniqueKeys().size();
		ResetFTAlgoTimed resetFTAlgoTimed(currentProject, m_DFaultSet, m , m_faultSets , m_resetableSets);
		resetFTAlgoTimed.provideProgress(NULL);
		m_isTimedResetFaultsControllable = resetFTAlgoTimed.runAlgo();
	}
	else
	{
		QMessageBox msgBox;
		msgBox.setText("The project does not have any fault sets defined.");
		msgBox.setIcon(QMessageBox::Information);
		msgBox.exec();
	}
}
//___________________________________________________________________________________________________________________________________________________
void FaultTolerant::runResettableFTNonBlockTool(const DesProject& currentProject)
{
	// check that excluded fault set is valid
	if (! (currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	// check that  fault and reset sets are valid
	if (! (currentProject.isFaultSetsValid()) )  {
	   throw EX("Fault and reset sets not checked. Please run fault sets dialog.");
	}  

	if (!(m_faultSets.isEmpty()))
	{
		int m = m_faultSets.uniqueKeys().size();
		ResetFTAlgoNonBlock resetFTAlgoNonBlock(currentProject, m_DFaultSet, m , m_faultSets, m_resetableSets);
		resetFTAlgoNonBlock.provideProgress(NULL);
		m_isResetFaultsNonblocking = resetFTAlgoNonBlock.runAlgo();
	}
	else
	{
		QMessageBox msgBox;
		msgBox.setText("The project does not have any fault sets defined.");
		msgBox.setIcon(QMessageBox::Information);
		msgBox.exec();
	}
}
//===================================================================================================================================================
//BDD Cont.
BDDSD::SD_CtrlChkInfo FaultTolerant::runBDDDFTCtrlTool(const DesProject& currentProject, QWidget* parent)
{
	BDDDefaultFTAlgo BDDdefaultFTAlgo(currentProject, m_DFaultSet);	
	BDDdefaultFTAlgo.provideProgress(NULL);
	return BDDdefaultFTAlgo.runBDDFTCtrlAlgo();
}
//===================================================================================================================================================
BDDSD::SD_TCtrlChkInfo FaultTolerant::runTimedBDDDFTCtrlTool(const DesProject& currentProject, QWidget* parent)
{
	BDDDefaultFTAlgoTimed BDDdefaultFTAlgo(currentProject, m_DFaultSet);	
	BDDdefaultFTAlgo.provideProgress(NULL);
	return BDDdefaultFTAlgo.runTimedBDDFTCtrlAlgo();
}
//___________________________________________________________________________________________________________________________________________________
BDDSD::SD_CtrlChkInfo FaultTolerant::runBDDNFTCtrlTool(const DesProject& currentProject, int N, QWidget* parent)
{
	// check that excluded fault set is valid
	if (! (currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	// check that  fault and reset sets are valid
	if (! (currentProject.isFaultSetsValid()) )  {
	   throw EX("Fault and reset sets not checked. Please run fault sets dialog.");
	}  

	if (!(m_faultSets.isEmpty()))
	{
		BDDNFaultsAlgo BDDnFAlgo(currentProject, m_DFaultSet , N, m_faultSets);	
		BDDnFAlgo.provideProgress(NULL);
		return BDDnFAlgo.runBDDFTCtrlAlgo();
	}
	else
	{
		throw EX("The project does not have any fault sets defined.");
	}
}
//___________________________________________________________________________________________________________________________________________________
BDDSD::SD_TCtrlChkInfo FaultTolerant::runTimedBDDNFTCtrlTool(const DesProject& currentProject, int N, QWidget* parent)
{
	// check that excluded fault set is valid
	if (! (currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	// check that  fault and reset sets are valid
	if (! (currentProject.isFaultSetsValid()) )  {
	   throw EX("Fault and reset sets not checked. Please run fault sets dialog.");
	}  

	if (!(m_faultSets.isEmpty()))
	{
		BDDNFaultsAlgoTimed BDDnFAlgo(currentProject, m_DFaultSet , N, m_faultSets);	
		BDDnFAlgo.provideProgress(NULL);
		return BDDnFAlgo.runTimedBDDFTCtrlAlgo();
	}
	else
	{
		throw EX("The project does not have any fault sets defined.");
	}
}
//___________________________________________________________________________________________________________________________________________________
BDDSD::SD_CtrlChkInfo FaultTolerant::runBDDNonRepNFTCtrlTool(const DesProject& currentProject, int N, QWidget* parent)
{
	// check that excluded fault set is valid
	if (! (currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	// check that  fault and reset sets are valid
	if (! (currentProject.isFaultSetsValid()) )  {
	   throw EX("Fault and reset sets not checked. Please run fault sets dialog.");
	}  

	int m = m_faultSets.uniqueKeys().size();

	if (!(m_faultSets.isEmpty()))
	{
		BDDNonRepFTAlgo BDDnonRepFTAlgo(currentProject, m_DFaultSet , m, N, m_faultSets);
		BDDnonRepFTAlgo.provideProgress(NULL);
		return BDDnonRepFTAlgo.runBDDFTCtrlAlgo();
	}
	else
	{
		throw EX("The project does not have any fault sets defined.");
	}
}
//___________________________________________________________________________________________________________________________________________________
BDDSD::SD_TCtrlChkInfo FaultTolerant::runTimedBDDNonRepNFTCtrlTool(const DesProject& currentProject, int N, QWidget* parent)
{
	// check that excluded fault set is valid
	if (! (currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	// check that  fault and reset sets are valid
	if (! (currentProject.isFaultSetsValid()) )  {
	   throw EX("Fault and reset sets not checked. Please run fault sets dialog.");
	}  

	int m = m_faultSets.uniqueKeys().size();

	if (!(m_faultSets.isEmpty()))
	{
		BDDNonRepFTAlgoTimed BDDnonRepFTAlgo(currentProject, m_DFaultSet , m, N, m_faultSets);
		BDDnonRepFTAlgo.provideProgress(NULL);
		return BDDnonRepFTAlgo.runTimedBDDFTCtrlAlgo();
	}
	else
	{
		throw EX("The project does not have any fault sets defined.");
	}
}
//___________________________________________________________________________________________________________________________________________________
BDDSD::SD_CtrlChkInfo FaultTolerant::runBDDResettableFTCtrlTool(const DesProject& currentProject)
{
	// check that excluded fault set is valid
	if (! (currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	// check that  fault and reset sets are valid
	if (! (currentProject.isFaultSetsValid()) )  {
	   throw EX("Fault and reset sets not checked. Please run fault sets dialog.");
	}  

	if (!(m_faultSets.isEmpty()))
	{
		int m = m_faultSets.uniqueKeys().size();
		BDDResetFTAlgo BDDresetFTAlgo(currentProject, m_DFaultSet, m , m_faultSets, m_resetableSets);
		BDDresetFTAlgo.provideProgress(NULL);
		return BDDresetFTAlgo.runBDDFTCtrlAlgo();
	}
	else
	{
		throw EX("The project does not have any fault sets defined.");
	}
}
//___________________________________________________________________________________________________________________________________________________
BDDSD::SD_TCtrlChkInfo FaultTolerant::runTimedBDDResettableFTCtrlTool(const DesProject& currentProject)
{
	// check that excluded fault set is valid
	if (! (currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	// check that  fault and reset sets are valid
	if (! (currentProject.isFaultSetsValid()) )  {
	   throw EX("Fault and reset sets not checked. Please run fault sets dialog.");
	}  

	if (!(m_faultSets.isEmpty()))
	{
		int m = m_faultSets.uniqueKeys().size();
		BDDResetFTAlgoTimed BDDresetFTAlgo(currentProject, m_DFaultSet, m , m_faultSets, m_resetableSets);
		BDDresetFTAlgo.provideProgress(NULL);
		return BDDresetFTAlgo.runTimedBDDFTCtrlAlgo();
	}
	else
	{
		throw EX("The project does not have any fault sets defined.");
	}
}
//===================================================================================================================================================
//BDD Nonblocking
BDDSD::SD_NBChkInfo FaultTolerant::runBDDDFTNonblockingTool(const DesProject& currentProject, QWidget* parent)
{
	BDDDefaultFTAlgoNonblocking BDDdefaultFTAlgoNonblocking(currentProject, m_DFaultSet);	
	BDDdefaultFTAlgoNonblocking.provideProgress(NULL);
	return BDDdefaultFTAlgoNonblocking.runBDDFTNonblockingAlgo();
}
//___________________________________________________________________________________________________________________________________________________
BDDSD::SD_NBChkInfo FaultTolerant::runBDDNFTNonblockingTool(const DesProject& currentProject, int N, QWidget* parent)
{
	// check that excluded fault set is valid
	if (! (currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	// check that  fault and reset sets are valid
	if (! (currentProject.isFaultSetsValid()) )  {
	   throw EX("Fault and reset sets not checked. Please run fault sets dialog.");
	}  

	if (!(m_faultSets.isEmpty()))
	{
		BDDNFaultsAlgoNonblocking BDDnFAlgoNonblocking(currentProject, m_DFaultSet , N, m_faultSets);	
		BDDnFAlgoNonblocking.provideProgress(NULL);
		return BDDnFAlgoNonblocking.runBDDFTNonblockingAlgo();
	}
	else
	{
		throw EX("The project does not have any fault sets defined.");
	}
}
//___________________________________________________________________________________________________________________________________________________
BDDSD::SD_NBChkInfo FaultTolerant::runBDDNonRepNFTNonblockingTool(const DesProject& currentProject, int N, QWidget* parent)
{
	// check that excluded fault set is valid
	if (! (currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	// check that  fault and reset sets are valid
	if (! (currentProject.isFaultSetsValid()) )  {
	   throw EX("Fault and reset sets not checked. Please run fault sets dialog.");
	}  

	int m = m_faultSets.uniqueKeys().size();

	if (!(m_faultSets.isEmpty()))
	{
		BDDNonRepFTAlgoNonblocking BDDnonRepFTAlgoNonblocking(currentProject, m_DFaultSet , m, N, m_faultSets);
		BDDnonRepFTAlgoNonblocking.provideProgress(NULL);
		return BDDnonRepFTAlgoNonblocking.runBDDFTNonblockingAlgo();
	}
	else
	{
		throw EX("The project does not have any fault sets defined.");
	}
}
//___________________________________________________________________________________________________________________________________________________
BDDSD::SD_NBChkInfo FaultTolerant::runBDDResettableFTNonblockingTool(const DesProject& currentProject)
{
	// check that excluded fault set is valid
	if (! (currentProject.isExcldEvntsValid()) )  {
	   throw EX("Excluded fault set not checked. Please run excluded fault set dialog.");
	}  

	// check that  fault and reset sets are valid
	if (! (currentProject.isFaultSetsValid()) )  {
	   throw EX("Fault and reset sets not checked. Please run fault sets dialog.");
	}  

	if (!(m_faultSets.isEmpty()))
	{
		int m = m_faultSets.uniqueKeys().size();
		BDDResetFTAlgoNonblocking BDDresetFTAlgoNonblocking(currentProject, m_DFaultSet, m , m_faultSets, m_resetableSets);
		BDDresetFTAlgoNonblocking.provideProgress(NULL);
		return BDDresetFTAlgoNonblocking.runBDDFTNonblockingAlgo();
	}
	else
	{
		throw EX("The project does not have any fault sets defined.");
	}
}
//___________________________________________________________________________________________________________________________________________________
}
