/*************************************************************************
 * This file is part of the Distributed Computation feature
 *
 * Project created in conformity with the requirements for the Degree of
 * Master of Engineering in Software Engineering, Computing and Software
 * Department, McMaster University 2012
 *
 * Author:	David Kirby
 * Supervisor: Dr. Ryan Leduc
 *
 * Description: A monitor class that maintains a list of slave nodes and
 * controls access to them.
 ************************************************************************/
#pragma once

#include <vector>
#include <string>
#include <fstream>
#include <algorithm>
#include <deque>

#include "CommonDefinitions.h"
#include "HostFileManager.h"
#include "SpawnWrapper.h"
#include "Host.h"

#ifdef __ENABLE_DIST__
#include <pthread.h>
#endif

namespace DESpot
{
	class HostList
	{
		public:
			HostList(int maxhosts = -99);

		public:
			Host* getHost();
			void freeHost(Host* host);
			int count();

			void clearHostList();

		private:			
			static std::vector<Host*> m_hosts;
			static deque<int> m_freeHosts;
			static int m_maxHosts;

#ifdef __ENABLE_DIST__
			static pthread_mutex_t m_hostListMutex;
			static pthread_cond_t m_hostListCond;
#endif
	};
}
