/*	Author: Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <string>
#include "MultiCtrlAlgo.h"
#include "DesSubsystem.h"

namespace DESpot
{
	class LowSubsysCtrlAlgo : public MultiCtrlAlgo
	{
		public:
			LowSubsysCtrlAlgo(const DesSubsystem& subsytem);
			virtual ~LowSubsysCtrlAlgo(void);

		public:
			virtual bool runAlgo();

			const DesSubsystem& getInputSubsystem() {return m_subsystem;}

	protected:
			virtual void prepareRun();
			virtual std::wstring prepareErrorDescription();

		protected:
			const DesSubsystem& m_subsystem;

		private:
			static const std::wstring cLowSubsysCtrlAlgoDesc;
			static const std::wstring cLowSubsysCtrlError;
		//added by zain for counter example
			DesHierProject* m_project;
		public:
			inline void set_proj(DesHierProject* in_proj){m_project=in_proj;}
			inline DesHierProject* get_proj(){return m_project;}
	};
}
