/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2015
*/

#pragma once
#include <iostream>
#include "NFaultsAlgoNonBlock.h"
#include "MultiNonBlockingAlgo.h"
#include "FlatProjIntegrityAlgo.h"

namespace DESpot

{
NFaultsAlgoNonBlock::NFaultsAlgoNonBlock(const DesProject& currentProject, QList<QString>& faultSet ,int N , QMultiMap<int,QString>& faultSets): NFaultsAlgo(currentProject, faultSet, N, faultSets), m_isNFaultsNonblocking(false)
{
}
//____________________________________________________________________________________________________________________________________	
NFaultsAlgoNonBlock::~NFaultsAlgoNonBlock()
{
}
//____________________________________________________________________________________________________________________________________

bool NFaultsAlgoNonBlock::runAlgo()
{
	DefaultFTAlgo::createDummyFlatProject();
	if (! m_faultSet.isEmpty())
	{
		DefaultFTAlgo::constructGF();	
		DefaultFTAlgo::addGF();
	}
	int m = m_faultSets.uniqueKeys().size();
	if (m_N < m)
	{
		NFaultsAlgo::constructGNF();
		NFaultsAlgo::addGNF();
	}
	return NFaultsAlgoNonBlock::verifyFTNonBlocking();

}
//____________________________________________________________________________________________________________________________________
bool NFaultsAlgoNonBlock::verifyFTNonBlocking()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		MultiNonBlockingAlgo flatNonBlock;
		DesSubsystem::DesIteratorPtr hDesIt = m_flatDummyProject->createDesIterator();
		for(hDesIt->first(); hDesIt->notDone(); hDesIt->next())
		{
			const Des& hDes = hDesIt->currentItem();
			flatNonBlock.addInputDes(&hDes);
		}
		m_isNFaultsNonblocking = (m_flatDummyProject->checkNonBlocking(flatNonBlock));
		return (m_isNFaultsNonblocking);
	}
	else
	{throw EX("Project Integrity test has failed");}
	return m_isNFaultsNonblocking;
}
//____________________________________________________________________________________________________________________________________
bool NFaultsAlgoNonBlock::isNFaultsNonblocking() const
{
	return m_isNFaultsNonblocking;
}
//____________________________________________________________________________________________________________________________________
}


