/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2015
*/

#pragma once
#include <iostream>
#include "NFaultsAlgoTimed.h"
#include "TimedCtrl.h"
#include "FlatProjIntegrityAlgo.h"

namespace DESpot

{
NFaultsAlgoTimed::NFaultsAlgoTimed(const DesProject& currentProject, QList<QString>& faultSet ,int N , QMultiMap<int,QString>& faultSets): NFaultsAlgo(currentProject, faultSet, N, faultSets),m_isTimedNFaultsControllable(false)
{
}
//____________________________________________________________________________________________________________________________________	
NFaultsAlgoTimed::~NFaultsAlgoTimed()
{
}
//____________________________________________________________________________________________________________________________________
bool NFaultsAlgoTimed::runAlgo()
{
	DefaultFTAlgo::createDummyFlatProject();
	if (! m_faultSet.isEmpty())
	{
		DefaultFTAlgo::constructGFTimed();	
		DefaultFTAlgo::addGF();
	}
	int m = m_faultSets.uniqueKeys().size();
	if (m_N < m)
	{
		NFaultsAlgoTimed::constructGNF();
		NFaultsAlgo::addGNF();
	}
	return NFaultsAlgoTimed::verifyFTCtrl();

}
//____________________________________________________________________________________________________________________________________
void NFaultsAlgoTimed::constructGNF()
{
	if (! m_faultSets.empty())
	{
		
		const std::wstring& name = L"GNF" ;
		GNFDes = new Des(name , eRegularDes);
		
		DesState* InState = new DesState(0);
		InState->setIDasName();
		const DesState& Instate = GNFDes->addState(const_cast<DesState&>(*InState));
		GNFDes->changeStateMarking(Instate.getId(),true);
		GNFDes->changeStateInit(Instate.getId(),true);

		DesEvent* tickEvent = new DesEvent();
		const std::wstring& tickName = L"tick" ;
		const std::wstring& aliasName = L"t" ;
		tickEvent->setName(tickName);
		tickEvent->setAlias(aliasName);
		tickEvent->setControllable(true);
		const DesEvent& tickDESEvent = GNFDes->addEvent(const_cast<DesEvent&>(*tickEvent));
		GNFDes->addSelfTransition(tickDESEvent);

		QList<QString> faultEvents = m_faultSets.values();
		for (int i=0 ; i < faultEvents.size() ; i++)
		{ 
			QString eventName = faultEvents.at(i);
			const DesEvent* event;
			DesProject::DesIteratorPtr DESIt = m_currentProject.createDesIterator();
			for(DESIt->first(); DESIt->isDone() == false; DESIt->next())
			{
				const Des& currentDes = DESIt->currentItem();
				if (currentDes.findEvent(eventName.toStdWString(),event))
				{
					GNFDes->addEvent(const_cast<DesEvent&>(*event));
					break;
				}
			}
		}
	
		for (int j=1 ; j <= m_N ; j++)
		{
			const DesState& preState = GNFDes->getState(GNFDes->getLastUsedStateId());
			DesState* newState = new DesState(j+1);
			newState->setIDasName();
			const DesState& state = GNFDes->addState(const_cast<DesState&>(*newState));
			GNFDes->changeStateMarking(state.getId(),true);
			Des::EventIteratorPtr eventIt = GNFDes->createEventIterator();
			for(eventIt->first(); eventIt->isDone() == false; eventIt->next())
			{
				const DesEvent& event = eventIt->currentItem();
				DesTransition* trans = new DesTransition(preState , event , state);
				GNFDes->addTransition(const_cast<DesTransition&>(*trans));
			}		
		}
	}

}
//____________________________________________________________________________________________________________________________________
bool NFaultsAlgoTimed::verifyFTCtrl()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		TimedCtrl tCtrlAlgo(m_flatDummyProject->createDesIterator(ePlantDes),m_flatDummyProject->createDesIterator(eSupervisorDes));
		m_isTimedNFaultsControllable = m_flatDummyProject->checkTimedControllable(tCtrlAlgo);
		return m_isTimedNFaultsControllable;
	}
	else
	{throw EX("Project Integrity test has failed");}
}
//____________________________________________________________________________________________________________________________________
bool NFaultsAlgoTimed::isTimedNFaultsControllable() const
{
	return m_isTimedNFaultsControllable;
}
//____________________________________________________________________________________________________________________________________
}
