/*	Author:		Amal Alsuwaidan
	Supervisor: 	Dr. Ryan Leduc
	

	Project submitted to the Department of Computing and Software of McMaster University
	in partial fulfilment of the requirements for the degree of M.A.Sc in Software Engineering
	2012 - 2015
*/

#include <iostream>
#include <string> 
#include "NonRepFTAlgo.h"
#include "Des.h"
#include "DesFlatProject.h"
#include "FlatDummyProject.h"
#include "MultiCtrlAlgo.h"
#include "FlatProjIntegrityAlgo.h"
#include "DesIntegrityAlgo.h"

namespace DESpot

{
NonRepFTAlgo::NonRepFTAlgo(const DesProject& currentProject, QList<QString>& faultSet ,int M , int N , QMultiMap<int, QString>& faultSets): DefaultFTAlgo(currentProject, faultSet), m_M(M), m_N(N), m_faultSets(faultSets), m_isnonRepFaultsControllable(false)
{
}
//____________________________________________________________________________________________________________________________________	
NonRepFTAlgo::~NonRepFTAlgo()
{
}
//____________________________________________________________________________________________________________________________________
bool NonRepFTAlgo::runAlgo()
{

	DefaultFTAlgo::createDummyFlatProject();
	if (! m_faultSet.isEmpty())
	{	
		DefaultFTAlgo::constructGF();
		DefaultFTAlgo::addGF();
	}
	if (m_N < m_M)
	{
		NonRepFTAlgo::constructGNF();
		NonRepFTAlgo::addGNF();
	}
	if (m_N > 0)
	{
		NonRepFTAlgo::constructGFi();
	}
	return NonRepFTAlgo::verifyFTCtrl();

}
//____________________________________________________________________________________________________________________________________
void NonRepFTAlgo::constructGNF()
{
	if (! m_faultSets.empty())
	{
		
		const std::wstring& name = L"GNF" ;
		GNFDes = new Des(name , eRegularDes);
		
		DesState* InState = new DesState(0);
		//std::wstring& stateName = L"GNF"
		InState->setIDasName();
		const DesState& Instate = GNFDes->addState(const_cast<DesState&>(*InState));
		GNFDes->changeStateMarking(Instate.getId(),true);
		GNFDes->changeStateInit(Instate.getId(),true);

		QList<QString> faultEvents = m_faultSets.values();

		for (int i=0 ; i < faultEvents.size() ; i++)
		{ 
			QString eventName = faultEvents.at(i);
			const DesEvent* event;
			DesProject::DesIteratorPtr DESIt = m_currentProject.createDesIterator();
			for(DESIt->first(); DESIt->isDone() == false; DESIt->next())
			{
				const Des& currentDes = DESIt->currentItem();
				if (currentDes.findEvent(eventName.toStdWString(),event))
				{
					GNFDes->addEvent(const_cast<DesEvent&>(*event));
					break;
				}
			}
		}
	
		for (int j=1 ; j <= m_N ; j++)
		{
			const DesState& preState = GNFDes->getState(GNFDes->getLastUsedStateId());
			DesState* newState = new DesState(j+1);
			newState->setIDasName();
			const DesState& state = GNFDes->addState(const_cast<DesState&>(*newState));

			GNFDes->changeStateMarking(state.getId(),true);
			Des::EventIteratorPtr eventIt = GNFDes->createEventIterator();
			for(eventIt->first(); eventIt->isDone() == false; eventIt->next())
			{
				const DesEvent& event = eventIt->currentItem();
				DesTransition* trans = new DesTransition(preState , event , state);
				GNFDes->addTransition(const_cast<DesTransition&>(*trans));
			}		
		}
	}

}
//____________________________________________________________________________________________________________________________________
void NonRepFTAlgo::addGNF()
{
	m_flatDummyProject->addPlantDes(GNFDes); 
}
//____________________________________________________________________________________________________________________________________
void NonRepFTAlgo::constructGFi()
{
	if (! m_faultSets.empty())
	{
		int i = 1;
		while ( i <= m_M)
		{
			string temp;
			ostringstream convert;
			convert << i;
			temp = convert.str();
			std::wstring wsi;
			std::wstring wsi2 = L"GFi";
			wsi.assign(temp.begin(), temp.end());
			wsi2.append(wsi);
			const std::wstring& name =wsi2;
			Des* GFiDes;
			GFiDes = new Des(name , eRegularDes);

			//const std::wstring& name = L"GFi" ;
			//GFiDes = new Des(name , eRegularDes);

			DesState* state1 = new DesState(0);
			state1->setIDasName();
			const DesState& InState1 = GFiDes->addState(const_cast<DesState&>(*state1));
			GFiDes->changeStateMarking(InState1.getId(),true);
			GFiDes->changeStateInit(InState1.getId(),true);

			DesState* state2 = new DesState(1);
			state2->setIDasName();
			const DesState& InState2 = GFiDes->addState(const_cast<DesState&>(*state2));
			GFiDes->changeStateMarking(InState2.getId(),true);

			QList<QString> faultEvents = m_faultSets.values(i);
			for (int j=0 ; j < faultEvents.size() ; j++)
			{ 	
				QString eventName = faultEvents.at(j);
				const DesEvent* event;
				DesProject::DesIteratorPtr DESIt = m_currentProject.createDesIterator();
				for(DESIt->first(); DESIt->isDone() == false; DESIt->next())
				{
					const Des& currentDes = DESIt->currentItem();
					if (currentDes.findEvent(eventName.toStdWString(),event))
					{	
						const DesEvent& newEvent = GFiDes->addEvent(const_cast<DesEvent&>(*event));
						DesTransition* trans = new DesTransition(InState1 , newEvent , InState2);
						GFiDes->addTransition(const_cast<DesTransition&>(*trans));
						break;
					}
				}
			}
			NonRepFTAlgo::addGFi(GFiDes);
			i++;
		}


	}
	else if (m_faultSets.empty())
		{throw EX("Fault Events List is empty.");}
}
//____________________________________________________________________________________________________________________________________
void NonRepFTAlgo::addGFi(Des* GFiDes)
{
	m_flatDummyProject->addPlantDes(GFiDes); 
}
//____________________________________________________________________________________________________________________________________
bool NonRepFTAlgo::verifyFTCtrl()
{ 
	FlatProjIntegrityAlgo integAlgo;
	if (m_flatDummyProject->checkIntegrity(integAlgo))
	{
		MultiCtrlAlgo ctrlAlgo(m_flatDummyProject->createDesIterator(ePlantDes),m_flatDummyProject->createDesIterator(eSupervisorDes));
		m_isnonRepFaultsControllable = (m_flatDummyProject->checkControllable(ctrlAlgo));

		return m_isnonRepFaultsControllable;
	}
	else
	{throw EX("Project Integrity test has failed");}
	return m_isnonRepFaultsControllable;
}
//____________________________________________________________________________________________________________________________________
bool NonRepFTAlgo::isnonRepFaultsControllable() const
{
	return m_isnonRepFaultsControllable;
}
//____________________________________________________________________________________________________________________________________
}


