#pragma once

#include <map>
#include "Iterator.h"
#include "CommonDefinitions.h"
#include "DecEvent.h"

namespace DESpot
{
    class ObserverCtrlEventIterator: public Iterator<DecEvent&, const DecEvent&>
    {
    public:
        ObserverCtrlEventIterator(const std::map<std::wstring, DecEvent*>& obsvCtrlEventMap):
                m_ObsvCtrlEventMap(obsvCtrlEventMap)
        {
        }

        virtual ~ObserverCtrlEventIterator(void)
        {
        }

    public:
        virtual void first() const
        {
            m_crtObsvCtrlEventIt = m_ObsvCtrlEventMap.begin();
        }

        virtual void next() const
        {
            m_crtObsvCtrlEventIt++;
        }

        virtual bool isDone() const
        {
            return (m_crtObsvCtrlEventIt == m_ObsvCtrlEventMap.end());
        }

        virtual DecEvent& currentItem()
        {
            if(m_crtObsvCtrlEventIt == m_ObsvCtrlEventMap.end())
                throw EX("Iterator is already done. Call isDone() before.")

            return const_cast<DecEvent&>(*(m_crtObsvCtrlEventIt->second));
        }

        virtual const DecEvent& currentItem() const
        {
            if(m_crtObsvCtrlEventIt == m_ObsvCtrlEventMap.end())
                throw EX("Iterator is already done. Call isDone() before.")

            return *(m_crtObsvCtrlEventIt->second);
        }

    private:
        ObserverCtrlEventIterator(const ObserverCtrlEventIterator& other) : m_ObsvCtrlEventMap(other.m_ObsvCtrlEventMap){}
        ObserverCtrlEventIterator& operator=(const ObserverCtrlEventIterator&)
        {
            return *this;
        }

    private:
        typedef std::map<std::wstring, DecEvent*>ObsvCtrlEventMap;
        typedef ObsvCtrlEventMap::const_iterator ObsvCtrlEventMapIt;

    private:
        const ObsvCtrlEventMap m_ObsvCtrlEventMap;
        mutable ObsvCtrlEventMapIt m_crtObsvCtrlEventIt;
    };
}
