/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include "ui_FlatProjectEditor.h"
#include "ui_HierProjectEditor.h"

#include "BddHiscMain.h"
#include "BddSdChkInfo.h"

#include "DesProject.h"
#include <list>

#include "DistCommon.h"



#include "DummyProjCreation.h"
#include "CounterExampleAlgo.h"
#include "CounterExampleAlgo_FlatCntr.h"
#include "CounterExampleAlgo_FlatNB.h"
#include "CounterExampleAlgo_LwCntr.h"
#include "CounterExampleAlgo_LwNB.h"
#include "CounterExampleAlgo_BDDFCntr.h"
#include "CounterExampleAlgo_BDDFNB.h"
#include "CounterExampleAlgo_BDDLwCntr.h"
#include "CounterExampleAlgo_BDDLwNB.h"
#include "CounterExampleAlgo_IAnsAccept.h"
#include "CounterExampleAlgo_IReqAcpt.h"
#include "CounterExampleAlgo_BDDIReqAcpt.h"
#include "CounterExampleAlgo_BDDAnsAcpt.h"
#include "CounterExampleAlgo_BDDTimedCheck.h"
#include "CounterExampleAlgo_IntfImpAlgo.h"
#include "DummyProject_BDD.h"
#include "FTAlgoTypes.h"


namespace DESpot
{	
	//class CtrlStdAlgo;
	class MultiCtrlAlgo;
	class TimedCtrl;
	class DefaultFTAlgo;
	class MultiNonBlockingAlgo;
	class ProjIntegrityAlgo;
	class LdInterfaceCheckAlgo;
	class IConsistAlgo;
	class LwNonBlockingAlgo;
	class LwCtrlAlgo;
	class DesHierProject;
	class IConsistAnsAcceptAlgo;
	class LowSubsysIConsistAlgo;
	class HighSubsysNonBlockAlgo;
	class LowSubsysNonBlockAlgo;
	class HighSubsysCtrlAlgo;
	class LowSubsysCtrlAlgo;
	class FlatProjectPropCheck;
	class HierProjectPropCheck;
	class ProjectEvent;

	class FaultTolerant;
	class CoObsAlgo;	
	
	class OutputUiPart : QObject
	{
		Q_OBJECT

		public:
			

			enum LastOutputOption
			{
				eSetLastOutput = 1,
				eAppendLastOutput = 2
			};

			enum OutputSource
			{
				eProjectIntegrityCheck,
				eNonBlockingCheck,
				eControllabilityCheck,
				eTimedControllabilityCheck,
				eInterfConsistCheck,
				eLwNonblockingCheck,
				eLwCtrlCheck,
				eSubsysInterfConsistCheck,
				eLdInterfCheck,
				eSubsysNonblockingCheck,
				eSubsysCtrlCheck,
				eProjectPropCheck,

				eFaultTolerant,
				eDefaultFTCtrl,
				eDefaultFTNonBlock,
				eDefaultFTCtrlTimed,
				eNFFTCtrl,
				eNFFTNonBlock,
				eNFFTCtrlTimed,
				eNonRepFTCtrl,
				eNonRepFTNonBlock,
				eNonRepFTCtrlTimed,
				eResettableFTCtrl,
				eResettableFTNonBlock,
				eResettableFTCtrlTimed,
				eCoObservabilityCheck
			};
			
	public:
		typedef std::list<std::wstring> ErrorList;
	    typedef ErrorList::iterator ErrorListIt;

		public:
			OutputUiPart(Ui::FlatProjectEditorUI* pUiContainer, DesProject* pProject);
			OutputUiPart(Ui::HierProjectEditorUI* pUiContainer, DesProject* pProject);
			virtual ~OutputUiPart(void);
			
			void setOwnerTabWidget(QTabWidget* tabWidget);

		public:
			void show(ProjIntegrityAlgo& integAlgo, bool showMsgBox);
			void show(ProjIntegrityAlgo& integAlgo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);

			void show(MultiNonBlockingAlgo& nonBlockAlgo, bool showMsgBox);
			void show(MultiNonBlockingAlgo& nonBlockAlgo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			
			//void show(CtrlStdAlgo& ctrlAlgo, bool showMsgBox);
			//void show(CtrlStdAlgo& ctrlAlgo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);

			void show(MultiCtrlAlgo& ctrlAlgo, bool showMsgBox);
			void show(MultiCtrlAlgo& ctrlAlgo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
//------------------------------------------------------------------------------------------------------------------------------------------
			//Added by Amal for TDES
			void show(TimedCtrl& tCtrlAlgo, bool showMsgBox);
			void show(TimedCtrl& tCtrlAlgo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);

			//Added by Amal for FT Ctrl
			void show(FTAlgoCtrl ftAlgoCtrl, FaultTolerant& faultTolerant, int N, bool showMsgBox); 
			void show(FTAlgoCtrl ftAlgoCtrl, FaultTolerant& faultTolerant, int N, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true); 
			//Added by Amal for FT nonblocking
			void show(FTAlgoNonblocking ftAlgoNonblocking, FaultTolerant& faultTolerant, int N, bool showMsgBox); 
			void show(FTAlgoNonblocking ftAlgoNonblocking, FaultTolerant& faultTolerant, int N, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true); 

			//Added by Amal for Timed FT Ctrl
			void show(TimedFTAlgoCtrl timedFTAlgoCtrl, FaultTolerant& faultTolerant, int N, bool showMsgBox);
			void show(TimedFTAlgoCtrl timedFTAlgoCtrl, FaultTolerant& faultTolerant, int N, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
//------------------------------------------------------------------------------------------------------------------------------------------			
			void show(CoObsAlgo& coObsAlgo, bool showMsgBox);
			void show(CoObsAlgo& coObsAlgo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);

			void showMeasurements(const Des* flatSystem);

			void show(LdInterfaceCheckAlgo& ldInterfCheckAlgo, bool showMsgBox);
			void show(LdInterfaceCheckAlgo& ldInterfCheckAlgo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);

			void show(IConsistAnsAcceptAlgo& ansAcceptAlgo, bool showMsgBox);
			void show(IConsistAnsAcceptAlgo& ansAcceptAlgo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			
			void show(LowSubsysIConsistAlgo& lowSubsysIConsAlgo, bool showMsgBox);
			void show(LowSubsysIConsistAlgo& lowSubsysIConsAlgo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			void show(std::wstring subsysName, bool showMsgBox);
			void show(std::wstring subsysName, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
							 
			void show(IConsistAlgo& iConsAlgo, bool showMsgBox);
			void show(IConsistAlgo& iConsAlgo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			
			void show(LwNonBlockingAlgo& lwNonBlockAlgo, bool showMsgBox);
			void show(AlgoType algoType, bool showMsgBox);
			void show(LwNonBlockingAlgo& lwNonBlockAlgo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			void show(AlgoType algoType,LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			
			void show(LwCtrlAlgo& lwCtrlAlgo, bool showMsgBox);
			void show(LwCtrlAlgo& lwCtrlAlgo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);

			void show(HighSubsysNonBlockAlgo& hSubsysNonBlockAlgo, bool showMsgBox);
			void show(HighSubsysNonBlockAlgo& hSubsysNonBlockAlgo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			
			void show(LowSubsysNonBlockAlgo& lowSubsysNonBlockAlgo, bool showMsgBox);
			void show(LowSubsysNonBlockAlgo& lowSubsysNonBlockAlgo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			
			void show(HighSubsysCtrlAlgo& hSubsysCtrlAlgo, bool showMsgBox);
			void show(HighSubsysCtrlAlgo& hSubsysCtrlAlgo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			
			void show(LowSubsysCtrlAlgo& lowSubsysCtrlAlgo, bool showMsgBox);
			void show(LowSubsysCtrlAlgo& lowSubsysCtrlAlgo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);

			void show(FlatProjectPropCheck& projCheckAlgo);
			void show(HierProjectPropCheck& projCheckAlgo);

			void show(OutputSource source, std::wstring heading, std::wstring error, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);

#ifdef __ENABLE_BDD__
			void show(BDDSD::SD_NBChkInfo& checkInfo, bool showMsgBox);
			void show(BDDSD::SD_NBChkInfo& checkInfo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			void show(BDDSD::SD_CtrlChkInfo& checkInfo, bool showMsgBox);
			void show(BDDSD::SD_CtrlChkInfo& checkInfo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			
			//Added by Amal for BDD FT Cont. check
			void show(FTAlgoCtrl ftAlgoCtrl, BDDSD::SD_CtrlChkInfo& checkInfo, int N, bool showMsgBox);
			void show(FTAlgoCtrl ftAlgoCtrl, BDDSD::SD_CtrlChkInfo& checkInfo, int N, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			void show(TimedFTAlgoCtrl timedFTAlgoCtrl, BDDSD::SD_TCtrlChkInfo& checkInfo, int N, bool showMsgBox);
			void show(TimedFTAlgoCtrl timedFTAlgoCtrl, BDDSD::SD_TCtrlChkInfo& checkInfo, int N, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);


			//Added by Amal for BDD FT Nonblocking check
			void show(FTAlgoNonblocking ftAlgoNonblocking, BDDSD::SD_NBChkInfo& checkInfo, int N, bool showMsgBox);
			void show(FTAlgoNonblocking ftAlgoNonblocking, BDDSD::SD_NBChkInfo& checkInfo, int N, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);


			void show(BDDSD::SD_TCtrlChkInfo& checkInfo, bool showMsgBox);
			void show(BDDSD::SD_TCtrlChkInfo& checkInfo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			void show(BDDSD::SD_SDCtrlChkInfo& checkInfo, bool showMsgBox);
			void show(BDDSD::SD_SDCtrlChkInfo& checkInfo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			void show(BDDSD::SD_PTBChkInfo& checkInfo, bool showMsgBox);
			void show(BDDSD::SD_PTBChkInfo& checkInfo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			void show(BDDSD::SD_SSingPChkInfo& checkInfo, bool showMsgBox);
			void show(BDDSD::SD_SSingPChkInfo& checkInfo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			void show(BDDSD::SD_PCmpltChkInfo& checkInfo, bool showMsgBox);
			void show(BDDSD::SD_PCmpltChkInfo& checkInfo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			void show(BDDSD::SD_ALFChkInfo& checkInfo, bool showMsgBox);
			void show(BDDSD::SD_ALFChkInfo& checkInfo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);


			void show(BDDHISC::Hisc_LWNBChkInfo& checkInfo, bool showMsgBox);
			void show(BDDHISC::Hisc_LWNBChkInfo& checkInfo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			void show(BDDHISC::Hisc_SubLWNBChkInfo& checkInfo, bool showMsgBox);
			void show(BDDHISC::Hisc_SubLWNBChkInfo& checkInfo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			void show(BDDHISC::Hisc_LWContChkInfo& checkInfo, bool showMsgBox);
			void show(BDDHISC::Hisc_LWContChkInfo& checkInfo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			void show(BDDHISC::Hisc_SubLWContChkInfo& checkInfo, bool showMsgBox);
			void show(BDDHISC::Hisc_SubLWContChkInfo& checkInfo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			void show(BDDHISC::Hisc_IConsisChkInfo& checkInfo, bool showMsgBox);
			void show(BDDHISC::Hisc_IConsisChkInfo& checkInfo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			void show(BDDHISC::Hisc_SubIConsisChkInfo& checkInfo, bool showMsgBox);
			void show(BDDHISC::Hisc_SubIConsisChkInfo& checkInfo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			void show(BDDHISC::Hisc_LDIntfChkInfo& checkInfo, bool showMsgBox);
			void show(BDDHISC::Hisc_LDIntfChkInfo& checkInfo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
		
			void show(BDDHISC::Hisc_LWSynthChkInfo& checkInfo, bool showMsgBox);
			void show(BDDHISC::Hisc_LWSynthChkInfo& checkInfo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			void show(BDDHISC::Hisc_SubLWSynthChkInfo& checkInfo, bool showMsgBox);
			void show(BDDHISC::Hisc_SubLWSynthChkInfo& checkInfo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);

			//Overload for output for the multi-level project
			void show(BDDHISC::Hisc_SubLWNBChkInfo& checkInfo, bool isHigh,bool showMsgBox);
			void show(bool isHigh,BDDHISC::Hisc_SubLWNBChkInfo& checkInfo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			void show(BDDHISC::Hisc_SubLWContChkInfo& checkInfo, bool isHigh, bool showMsgBox);
			void show(bool isHigh, BDDHISC::Hisc_SubLWContChkInfo& checkInfo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			void show(BDDHISC::Hisc_SubIConsisChkInfo& checkInfo, bool isHigh, bool isMiddle, bool showMsgBox);
			void show(bool isHigh, bool isMiddle, BDDHISC::Hisc_SubIConsisChkInfo& checkInfo, LastOutputOption copyToLastOutput = eSetLastOutput, bool showMsgBox = true);
			//-----------------------------------------------------			
#endif

#ifdef __ENABLE_DIST__
			void show(resultStruct results, int time);
			void showFlat(resultStruct results, int time);
			void showMessage(const DesAlgo::ErrorList& msglist);
#endif
			void showTime(int time);

			void clearLastOutput();

		protected slots:
			void onShowOutputFor(int sourceIndex);
			void onToggleWrap();

		protected:
			//Initializes the widgets from either the flat project editor or the hierhical project editor
			//Called from the two constructors
			template<class T> 
			void initWidgets(T* pUiContainer);
			void initOutputSelectionWidget();
			void setupConnections();
			void saveOutput();
			void saveLastOutput(LastOutputOption copyToLastOutput);
			DesHierProject* hierProject();
			int getOutputIndexForSource(OutputSource source);
			void showErrors(const DesAlgo::ErrorList& errList);
			void saveErrors(const DesAlgo::ErrorList& errList);

		protected:
			QComboBox* m_showOutputForWidg;
			
			QToolButton* m_copyBtn;
			QToolButton* m_clearBtn;
			QToolButton* m_wrapBtn;

			OutputWidget* m_outputWidget;

			QTabWidget* m_tabWidget;
			DesProject* m_project;

		protected:
			static const QString cProjIntegOutputTitle;
			static const QString cNonBlockOutputTitle;
			static const QString cCtrlOutputTitle;
			static const QString cTimedCtrlOutputTitle;
			static const QString cCoObsOutputTitle;
			static const QString cSDCtrlOutputTitle;
			static const QString cPTBOutputTitle;
			static const QString cSSingPOutputTitle;
			static const QString cPCmpltOutputTitle;
			static const QString cALFOutputTitle;
			static const QString cSynthOutputTitle;
			static const QString cMeasureOutputTitle;

			static const QString cFaultTolerant;
			static const QString cFTCtrlOutputTitle;
			static const QString cFTCtrlTimedOutputTitle;
			static const QString cFTNonBlockOutputTitle;
			
			static const QString cInterfConsistOutputTitle;
			static const QString cLwNonBlockOutputTitle;
			static const QString cLwCtrlOutputTitle;
			static const QString cSubsysInterfConsistOutputTitle; 
			static const QString cLdInterfCheckTitle;
			static const QString cSubsysNonBlockingOutputTitle; 
			static const QString cSubsysCtrlOutputTitle;
			static const QString cLwSynthOutputTitle;
			static const QString cSubsysSynthOutputTitle;

			static const QString cLastOutputTitle;

			private:
				//added by zain for counter example genaration
				void GenerateCounterExample(BDDSD::SD_ChkInfo& checkinfo,QString errormsg);
				int GetDebugResponse(QString errormsg);	
				
	};
}
