/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/
#include <QHeaderView>
#include <QTreeWidgetItem>
#include "DespotTreeWidget.h"
#include "ProjStructureUiPart.h"
#include "CommonDefinitions.h"
#include "DesFlatProject.h"
#include "Des.h"
#include "ui_FlatProjectEditor.h"
#include "ui_HierProjectEditor.h"
//test
#include <iostream>
//#include "InstantiateTemplate.h"
#include "ProjectEditor.h"
#include "Instantiation.h"

using namespace std;
namespace DESpot
{

template void ProjStructureUiPart::initWidgets<Ui::FlatProjectEditorUI>(Ui::FlatProjectEditorUI*);
template void ProjStructureUiPart::initWidgets<Ui::HierProjectEditorUI>(Ui::HierProjectEditorUI*);

const int ProjStructureUiPart::cFlatProjStructColCount = 1;

ProjStructureUiPart::ProjStructureUiPart(DesProject* pProject):
	m_fViewRootItem(null),
        m_flatStructSupUiItem(null),
        m_flatStructPlantUiItem(null),
//add by bini
	m_flatStructTemplateUiItem(null),
	m_flatStructInstUiItem(null),
//bini
        m_pProject(pProject),
        m_pCrtDes(null),
	m_pCrtInst(null)

{
	//subscribe to the project's notifications
	m_projListnerId = m_pProject->subscribe(this);
}

//_________________________________________________________________________________________________

ProjStructureUiPart::~ProjStructureUiPart(void)
{
	m_pProject->unsubscribe(m_projListnerId);
}

//_________________________________________________________________________________________________

//returns the DES type of the current item in the out parameter. If it is a supervisor
//DES or it is the root of all supervisor DESs then it will
//return eSupervisorDes. If it is a plant or the root of all plant DESs
//it will return ePlantDes. If the type cannot be decided the method returns false
bool ProjStructureUiPart::getCurrentDesLevel(DesLevel& out_desLevel)
{
	QTreeWidgetItem* pCrtItem = m_fViewProjStructWidg->currentItem();
	
	if ((pCrtItem == m_flatStructSupUiItem) || (pCrtItem->parent() == m_flatStructSupUiItem))
	{
		out_desLevel = eSupervisorDes;
		return true;
	}
	else if ((pCrtItem == m_flatStructPlantUiItem) || (pCrtItem->parent() == m_flatStructPlantUiItem))
	{
		out_desLevel = ePlantDes;
		return true;
	}
//add by bini 	
	else if((pCrtItem == m_flatStructTemplateUiItem) || (pCrtItem->parent() == m_flatStructTemplateUiItem))
	{
		out_desLevel = eTemplateDes;
		return true;
	}
//bini
	else 
	{
		return false;
	}
}

//_________________________________________________________________________________________________

QMenu& ProjStructureUiPart::accessContextMenu()
{
	return m_projStructCtxtMenu;
}


//_________________________________________________________________________________________________

template<class T>
void ProjStructureUiPart::initWidgets(T* pUiContainer)
{
	m_fViewProjStructWidg = pUiContainer->m_fViewProjStructWidg;
}

//_________________________________________________________________________________________________

void ProjStructureUiPart::setupConnections()
{
	connect(m_fViewProjStructWidg, SIGNAL(currentItemChanged(QTreeWidgetItem*, QTreeWidgetItem*)), 
			this,					  SLOT(onChangedCurrentFlatViewItem(QTreeWidgetItem*, QTreeWidgetItem*)));

	connect(m_fViewProjStructWidg, SIGNAL(onWidthChanged(int)), 
		    this, SLOT(resizeProjFlatStructHeaders(int)));

	connect(m_fViewProjStructWidg, SIGNAL(itemActivated(QTreeWidgetItem*, int)),
			this, SLOT(onFlatStructItemActivated(QTreeWidgetItem*, int)));

	connect(m_fViewProjStructWidg, SIGNAL(onCurrentItemDeleted()),
			this, SLOT(onFlatStructItemDeleted()));
}

//_________________________________________________________________________________________________

void ProjStructureUiPart::setupProjectStructWidget()
{
	//setup up the columns
	m_fViewProjStructWidg->setColumnCount(cFlatProjStructColCount);
	
	//set the captions of each column
	QStringList headerCaption;
	headerCaption << STR_PROJ_STRUCT_HEADER;
	m_fViewProjStructWidg->setHeaderLabels(headerCaption);

	//insert default nodes, the root project node and the
	//the nodes for plant and supervisor DESs
	m_fViewRootItem = new QTreeWidgetItem(m_fViewProjStructWidg);
	QString projName = QString::fromStdWString(m_pProject->getName());
	m_fViewRootItem->setText(0, projName);
	m_fViewRootItem->setToolTip(0, projName);
	m_fViewProjStructWidg->expandItem(m_fViewRootItem);

	m_flatStructSupUiItem = new QTreeWidgetItem(m_fViewRootItem);
	m_flatStructSupUiItem->setText(0, STR_PROJ_STRUCT_SUP_ITEM);
	m_flatStructSupUiItem->setToolTip(0, STR_PROJ_STRUCT_SUP_ITEM_TOOLTIP(m_pProject->getSupDesCount()));
	m_fViewProjStructWidg->expandItem(m_flatStructSupUiItem);

	m_flatStructPlantUiItem = new QTreeWidgetItem(m_fViewRootItem);
	m_flatStructPlantUiItem->setText(0, STR_PROJ_STRUCT_PLANT_ITEM);
	m_flatStructPlantUiItem->setToolTip(0, STR_PROJ_STRUCT_PLANT_ITEM_TOOLTIP(m_pProject->getPlantDesCount()));
	m_fViewProjStructWidg->expandItem(m_flatStructPlantUiItem);
//add by BINI
	if(m_pProject->getType()==eFlatProject)
	{m_flatStructTemplateUiItem = new QTreeWidgetItem(m_fViewRootItem);
	m_flatStructTemplateUiItem->setText(0, STR_PROJ_STRUCT_TEMPLATE_ITEM);
	m_flatStructTemplateUiItem->setToolTip(0, STR_PROJ_STRUCT_TEMPLATE_ITEM_TOOLTIP(m_pProject->getTemplateDesCount()));
	m_fViewProjStructWidg->expandItem(m_flatStructTemplateUiItem);	}
//bini

//add the context menu
	m_fViewProjStructWidg->setContextMenu(m_projStructCtxtMenu);

	m_fViewProjStructWidg->setCurrentItem(m_fViewRootItem);
	//m_fViewProjStructWidg->expandAll();
}

//_________________________________________________________________________________________________

void ProjStructureUiPart::addSupDesToUiItem(QTreeWidgetItem* item, DesProject::DesIteratorPtr& desIt)
{
	//add DES items to the given container item
	for(desIt->first(); desIt->isDone() == false; desIt->next())
	{
		const Des& des = desIt->currentItem();

		//create a new item and add it to the parent
		QString itemText = QString::fromStdWString(des.getName());
		QString desFileName = QString::fromStdWString(des.getFileName());
		QString itemTooltip =  itemText + " - " + desFileName;
		
		//add the newly created item to the proper parent depending on the type (sup or plant) and
		//update the tooltip of the parent item with the number of DESs
		createFlatViewDesItem(itemText,itemTooltip, item, &des); 
	}

	item->setToolTip(0, STR_PROJ_STRUCT_SUP_ITEM_TOOLTIP(item->childCount()));
}

//_________________________________________________________________________________________________

void ProjStructureUiPart::addPlantDesToUiItem(QTreeWidgetItem* item, DesProject::DesIteratorPtr& desIt)
{
	//add DES items to the given container item
	for(desIt->first(); desIt->isDone() == false; desIt->next())
	{
		const Des& des = desIt->currentItem();

		//create a new item and add it to the parent
		QString itemText = QString::fromStdWString(des.getName());
		QString desFileName = QString::fromStdWString(des.getFileName());
		QString itemTooltip =  itemText + " - " + desFileName;
		
		//add the newly created item to the proper parent depending on the type (sup or plant) and
		//update the tooltip of the parent item with the number of DESs
		/*QTreeWidgetItem* desItem = */
                createFlatViewDesItem(itemText,itemTooltip, item, &des); 
					
	}

	item->setToolTip(0, STR_PROJ_STRUCT_PLANT_ITEM_TOOLTIP(item->childCount()));
}

//___________________________________________________________________________________________________
//add by bini
void ProjStructureUiPart::addTemplateDesToUiItem(QTreeWidgetItem* item, DesProject::DesIteratorPtr& desIt, DesProject::InstIteratorPtr& instIt)
{
	//add DES items to the given container item
	for(desIt->first(); desIt->isDone() == false; desIt->next())
	{
		const Des& des = desIt->currentItem();

		//create a new item and add it to the parent
		QString itemText = QString::fromStdWString(des.getName());
		QString desFileName = QString::fromStdWString(des.getFileName());
		QString itemTooltip =  itemText + " - " + desFileName;
		
		//add the newly created item to the proper parent depending on the type (sup or plant) and
		//update the tooltip of the parent item with the number of DESs
		/*QTreeWidgetItem* desItem = */
		m_flatStructInstUiItem =createFlatViewDesItem(itemText,itemTooltip, item, &des);
		addInstToUiItem(m_flatStructInstUiItem,	instIt);		
	}

	item->setToolTip(0, STR_PROJ_STRUCT_TEMPLATE_ITEM_TOOLTIP(item->childCount()));
}
//BINI
//___________________________________________________________________________________________________
//add by bini
void ProjStructureUiPart::addInstToUiItem(QTreeWidgetItem* item, DesProject::InstIteratorPtr& instIt)
{
	Des* temp;	
	temp=&getDesFromFItem(*item);
	for(instIt->first(); instIt->isDone() == false; instIt->next())
	{
		if(instIt->currentItem().getTemplateDes()==temp)
		{const Instantiation& inst = instIt->currentItem();

		//create a new item and add it to the parent
		QString itemText = QString::fromStdWString(inst.getName());
		QString itemTooltip =  itemText;

		//add the newly created item to the proper parent depending on the type (sup or plant) and
		//update the tooltip of the parent item with the number of DESs
		/*QTreeWidgetItem* desItem = */
		createFlatViewInstItem(itemText,itemTooltip, item, &inst);
		}			
	}
	m_fViewProjStructWidg->expandAll();

}
//_______________________________________________________________________________________________


void ProjStructureUiPart::resizeProjFlatStructHeaders(int projStructWidgWidth)
{
	m_fViewProjStructWidg->header()->resizeSection(0, projStructWidgWidth);
}

//_________________________________________________________________________________________________

void ProjStructureUiPart::onProjectNameChanged(const std::wstring& newName, const std::wstring& /*oldName*/)
{
	m_fViewRootItem->setText(0, QString::fromStdWString(newName));
}

//_________________________________________________________________________________________________

void ProjStructureUiPart::onDesAdded(const Des& des, DesLevel desLevel)
{
	//create a new item and add it to the parent
	QString itemText = QString::fromStdWString(des.getName());
	QString desFileName = QString::fromStdWString(des.getFileName());
	QString itemTooltip =  itemText + " - " + desFileName;
	
	//add the newly created item to the proper parent depending on the type (sup or plant) and
	//update the tooltip of the parent item with the number of DESs
	QTreeWidgetItem* desItem = null;
	switch(desLevel)
	{
		case eSupervisorDes:
		{
			desItem = createFlatViewDesItem(itemText,itemTooltip, m_flatStructSupUiItem, &des); 
			m_flatStructSupUiItem->setToolTip(0, STR_PROJ_STRUCT_SUP_ITEM_TOOLTIP(m_pProject->getSupDesCount()));
			break;
		}

		case ePlantDes:
		{
			desItem = createFlatViewDesItem(itemText,itemTooltip, m_flatStructPlantUiItem, &des); 			
			m_flatStructPlantUiItem->setToolTip(0, STR_PROJ_STRUCT_PLANT_ITEM_TOOLTIP(m_pProject->getPlantDesCount()));
			break;
		}
//add by bini
		case eTemplateDes:
		{
			desItem = createFlatViewDesItem(itemText,itemTooltip, m_flatStructTemplateUiItem, &des); 			
			m_flatStructTemplateUiItem->setToolTip(0, STR_PROJ_STRUCT_TEMPLATE_ITEM_TOOLTIP(m_pProject->getTemplateDesCount()));

			//m_flatStructInstUiItem = new QTreeWidgetItem(desItem);
			//m_flatStructInstUiItem->setText(0, STR_PROJ_STRUCT_SUP_ITEM);
			//m_flatStructInstUiItem->setToolTip(0, STR_PROJ_STRUCT_SUP_ITEM_TOOLTIP(m_pProject->getSupDesCount()));
			//m_fViewProjStructWidg->expandItem(desItem);
			break;
		}

		default:
			assert(false);
	}	
	if(!des.isInstantiation())
	{	
		m_fViewProjStructWidg->setCurrentItem(desItem);
	}
}
//_________________________________________________________________________________________________
//add by bini
void ProjStructureUiPart::onInstAdded(Instantiation& inst,const Des& template_crt)
{
	QTreeWidgetItem* foundItem = null;
	QTreeWidgetItem* InstItem = null;
	searchDesInFViewItem(*m_flatStructTemplateUiItem, template_crt, foundItem);
	//create a new item and add it to the parent
	QString itemText = QString::fromStdWString(inst.getName());
	QString itemTooltip =  itemText;
	
	//add the newly created item to the proper parent depending on the type (sup or plant) and
	//update the tooltip of the parent item with the number of DESs
	//QTreeWidgetItem* InstItem = null;
	
	//ProjectEditor::InstInfoItr itr= instinfo->begin();
	
	//while(itr!=instinfo->end)	
	//{
		//QTreeWidgetItem* foundItem = getFViewInstInfoDlgItemFrom(const InstantiateTemplate& instinfodlg);
		//m_flatStructInstUiItem = new QTreeWidgetItem(InstItem->parent());
		m_fViewProjStructWidg->expandItem(foundItem);
		InstItem = createFlatViewInstItem(itemText,itemTooltip,foundItem,&inst); 
		//m_flatStructInstUiItem = new QTreeWidgetItem(foundItem);
		//m_fViewProjStructWidg->expandItem();
		//itr++;
	//}			

	m_fViewProjStructWidg->setCurrentItem(InstItem);
}
//_________________________________________________________________________________________________

void ProjStructureUiPart::onRemovingDes(const Des& des, DesLevel /*desLevel*/)
{
	//find and remove the UI Item corresponding to the DES being deleted
	QTreeWidgetItem* desItem = &getFViewItemFrom(des);
	removeDesItem(des, desItem, m_fViewProjStructWidg); 

	//reset the current item if the des being deleted is the current one
	if (m_pCrtDes == &des)
	{
		//assert(m_pCrtDes != &des); //the current des should have changed
		m_pCrtDes = null;
	}  

}

//_________________________________________________________________________________________________
//add by bini
void ProjStructureUiPart::onRemovingInstantiation(const Instantiation& inst)
{
	
	//find and remove the UI Item corresponding to the DES being deleted
	QTreeWidgetItem* instItem = &getFViewInstItemFrom(inst);

	removeInstantiationItem(inst, instItem, m_fViewProjStructWidg); 
	
	//reset the current item if the des being deleted is the current one
	if (m_pCrtInst == &inst)
	{
		
		//assert(m_pCrtInst != &inst); //the current des should have changed
		m_pCrtInst = null;
	}  

}

//_________________________________________________________________________________________________

void ProjStructureUiPart::onDesNameChanged(const Des& des, const std::wstring& /*oldName*/)
{
	QTreeWidgetItem& desItem = getFViewItemFrom(des);
	fillFlatViewDesItem(desItem, des);
}

//_________________________________________________________________________________________________
//modified by bini
QTreeWidgetItem* ProjStructureUiPart::createFlatViewDesItem(const QString& text, const QString& tooltip, 
QTreeWidgetItem* parent /*= null*/,const Des* des /*= null*/)
{
	//create a new item and add it to the parent
	QTreeWidgetItem* desItem = new QTreeWidgetItem(parent);
		
	desItem->setText(0, text);
	desItem->setToolTip(0, tooltip);
	
	//save the DES pointer in the item itsel for easy retrieval.
	//this pointer cannot be used to modify the DES but only to read things from it
	if(des)
	{
		desItem->setData(0, Qt::UserRole, QVariant(reinterpret_cast<unsigned long long>(des)));

		if(des->isInstantiation())
		{
			desItem->setTextColor(0,Qt::red);
		}
		
	}
	return desItem;
}

//_________________________________________________________________________________________________
//add by bini
QTreeWidgetItem* ProjStructureUiPart::createFlatViewInstItem(const QString& text, const QString& tooltip, 
QTreeWidgetItem* parent /*= null*/,const Instantiation* inst/*= null*/)
{
	//create a new item and add it to the parent
	QTreeWidgetItem* instItem = new QTreeWidgetItem(parent);
		
	instItem->setText(0, text);
	instItem->setToolTip(0, tooltip);

	if(inst)
	{
		instItem->setData(0, Qt::UserRole, QVariant(reinterpret_cast<unsigned long long>(inst)));
	}

	return instItem;
}

//_________________________________________________________________________________________________
//modified by bini
void ProjStructureUiPart::fillFlatViewDesItem(QTreeWidgetItem& desItem, const Des& des)
{
	QString itemText = QString::fromStdWString(des.getName());
	QString desFileName = QString::fromStdWString(des.getFileName());
	QString itemTooltip =  itemText + " - " + desFileName;

	desItem.setText(0, itemText);
	desItem.setToolTip(0, itemTooltip);
	
	//save the DES pointer in the item itsel for easy retrieval.
	//this pointer cannot be used to modify the DES but only to read things from it
	if (&des)
	{
		desItem.setData(0, Qt::UserRole, QVariant(reinterpret_cast<unsigned long long>(&des)));

	}
}

//_________________________________________________________________________________________________

Des& ProjStructureUiPart::getDesFromFItem(QTreeWidgetItem& desUiItem)
{
	Des* pDes = reinterpret_cast<Des*>(desUiItem.data(0, Qt::UserRole).toULongLong());
	if (pDes == null)
	{
		assert(pDes != null);
		throw EX("Cannot return DES. Given UI item doesn't represent a DES")
	}
	
	return *pDes;
}

//_________________________________________________________________________________________________
//add by bini

Instantiation& ProjStructureUiPart::getInstFromFItem(QTreeWidgetItem& instUiItem)
{
	Instantiation* pInst = reinterpret_cast<Instantiation*>(instUiItem.data(0, Qt::UserRole).toULongLong());
	if (pInst == null)
	{
		assert(pInst!= null);
		throw EX("Cannot return instantiaion. Given UI item doesn't represent a instantiation")
	}
	
	return *pInst;
}

//_________________________________________________________________________________________________
//modified by bini
//returns true if the given wiget item represents a project DES
bool ProjStructureUiPart::isDesFlatViewItem(QTreeWidgetItem& desUiItem)
{
	if ((&desUiItem == m_fViewProjStructWidg->topLevelItem(0)) ||
		(&desUiItem == m_flatStructSupUiItem) || (&desUiItem == m_flatStructPlantUiItem)||(&desUiItem == m_flatStructTemplateUiItem)/*||(&desUiItem == m_flatStructInstUiItem)*/)
	{
		return false;
	}

	return true;
}

//_________________________________________________________________________________________________

QTreeWidgetItem& ProjStructureUiPart::getFViewItemFrom(const Des& des)
{
	QTreeWidgetItem* foundItem = null;
	
	//search for the DES in the supervisor items
	if (searchDesInFViewItem(*m_flatStructSupUiItem, des, foundItem))
	{
		return *foundItem;
	}

	if (searchDesInFViewItem(*m_flatStructPlantUiItem, des, foundItem))
	{
		return *foundItem;
	}
//add by bini
    if(des.getParentSystemName().length()==0)
	{
	
    	if (searchDesInFViewItem(*m_flatStructTemplateUiItem, des, foundItem))
	{
		return *foundItem;
    }
	}

	//if we got here it means it was not in the list of supervior items nor in the plant ones.
	throw EX("Cannot locate given DES")
}

//_________________________________________________________________________________________________

bool ProjStructureUiPart::searchDesInFViewItem(QTreeWidgetItem& desContainerItem, const Des& des, QTreeWidgetItem*& out_foundItem)
{
	for(int iItem = 0; iItem < desContainerItem.childCount(); iItem++)
	{
		QTreeWidgetItem* crtItem = desContainerItem.child(iItem);
		Des& crtDes = getDesFromFItem(*crtItem);
		if (&crtDes == &des)
		{
			//found it
			out_foundItem = crtItem;
			return true;
		}
	}

	return false;
}

//_________________________________________________________________________________________________
//add by bini
//maybe not useful
QTreeWidgetItem& ProjStructureUiPart::getFViewInstItemFrom(const Instantiation& Inst)
{
	QTreeWidgetItem* foundItem = null;
	const Des* templatedes=Inst.getTemplateDes();
	QTreeWidgetItem& templateitem=getFViewItemFrom(*templatedes);
	if (searchInstInFViewItem(templateitem, Inst, foundItem))
	{
		return *foundItem;
	}


	//if we got here it means it was not in the list of supervior items nor in the plant ones.
	throw EX("Cannot locate the instantiation")
}

//_________________________________________________________________________________________________
//may be not useful
bool ProjStructureUiPart::searchInstInFViewItem(QTreeWidgetItem& instContainerItem, const Instantiation& Inst, QTreeWidgetItem*& out_foundItem)
{
	for(int iItem = 0; iItem < instContainerItem.childCount(); iItem++)
	{
		QTreeWidgetItem* crtItem = instContainerItem.child(iItem);
		Instantiation& crtInst = getInstFromFItem(*crtItem);
		if (&crtInst == &Inst)
		{
			//found it
			out_foundItem = crtItem;
			return true;
		}
	}

	return false;
}

//_________________________________________________________________________________________________

void ProjStructureUiPart::removeDesItem(const Des& /*des*/, QTreeWidgetItem* desItem, DespotTreeWidget* /*widget*/)
{
	//find and remove the UI Item corresponding to the DES being deleted
	QTreeWidgetItem* desItemParent = desItem->parent();
	int desItemIndex = desItemParent->indexOfChild(desItem);
	desItemParent->takeChild(desItemIndex);
}
//_________________________________________________________________________________________________
//add by bini
void ProjStructureUiPart::removeInstantiationItem(const Instantiation& /*inst*/, QTreeWidgetItem* instItem, DespotTreeWidget* /*widget*/)
{
	//find and remove the UI Item corresponding to the DES being deleted
	QTreeWidgetItem* instItemParent = instItem->parent();
	int instItemIndex = instItemParent->indexOfChild(instItem);
	instItemParent->takeChild(instItemIndex);
}

//_________________________________________________________________________________________________
//modified by bini
void ProjStructureUiPart::onChangedCurrentFlatViewItem(QTreeWidgetItem * current, QTreeWidgetItem * previous)
{	
	Des* pCrtDes = null;
	Instantiation* pCrtInst = null;
	QTreeWidgetItem* pPrvItem=previous->parent();
	QTreeWidgetItem* pCrtItem=current->parent();
	int flag1=0;
	int flag2=0;
	int flag3=0;
	int flag4=0;
	int flag5=0;
	int flag6=0;
	
	if (current)
	{
		if (isDesFlatViewItem(*current))
		{
			if(pCrtItem==m_flatStructSupUiItem||pCrtItem==m_flatStructPlantUiItem||pCrtItem==m_flatStructTemplateUiItem)
			{	
				flag1=1;
				pCrtDes = &getDesFromFItem(*current);
			}
			
			else if(pCrtItem->parent()==m_flatStructTemplateUiItem)
			{
				flag2=1;
				pCrtInst = &getInstFromFItem(*current);
			}
			
		
		}
		if(current==m_flatStructSupUiItem||current==m_flatStructPlantUiItem||current==m_flatStructTemplateUiItem)
		{
			flag5=1;
		}
	
	}

	Des* pOldCrtDes = null;
	Instantiation* pOldCrtInst = null;
	if (previous)
	{
		
		if (isDesFlatViewItem(*previous))
		{
			
			if(pPrvItem==m_flatStructSupUiItem||pPrvItem==m_flatStructPlantUiItem||pPrvItem==m_flatStructTemplateUiItem)
			{
				flag3=1;
				pOldCrtDes = &getDesFromFItem(*previous);
			}
			else if (pPrvItem->parent()==m_flatStructTemplateUiItem)
			{
				flag4=1;
				pOldCrtInst = &getInstFromFItem(*previous);
			}
		}
		if(previous==m_flatStructSupUiItem||previous==m_flatStructPlantUiItem||previous==m_flatStructTemplateUiItem)
		{
			flag6=1;
		}
		
	}
	
	if(isDesFlatViewItem(*current)||isDesFlatViewItem(*previous))
	{	

//change des to des 
		if((flag1==1&&flag3==1)||(flag1==1&&(!m_pCrtDes)))
		{
			//if (m_pCrtDes != pCrtDes)	
			//{
		
				m_pCrtDes = pCrtDes;
	
				emit onChangedCurrentDes(pCrtDes, pOldCrtDes);
		}
//change inst to des
		else if(flag1==1&&flag4==1)
		{
			if(pCrtItem==m_flatStructTemplateUiItem)
			{
				if (m_pCrtDes != pCrtDes)
				{
					m_pCrtDes = pCrtDes;
					emit onChangedCurrentDes(pCrtDes, pOldCrtDes);
				}
				else
				{
					emit onConnectEditDes();
				}
				emit onChangedInsttoTemplate();
				
			}
			else
			{	
				if (m_pCrtDes != pCrtDes)
				{
					m_pCrtDes = pCrtDes;
					emit onChangedCurrentDes(pCrtDes, pOldCrtDes);
				}
				else
				{
					emit onConnectEditDes();
				}
				emit onChangedInsttoDes(pCrtDes->isInstantiation());
				
			}
			emit onDisconnectEditInst();
		}
//change to uiitem	
		
		else if(flag5==1)
		{
			if (m_pCrtDes != pCrtDes)
			{
				m_pCrtDes = pCrtDes;
				emit onChangedCurrentDes(pCrtDes, pOldCrtDes);
			}
			emit onChangedUiItem();
		}
		//change des to inst
        else if((flag2==1&&flag3==1&&m_pCrtInst)||(!m_pCrtInst))
		{
			//change current item from des to inst	
			if (m_pCrtInst != pCrtInst)
			{
				m_pCrtInst = pCrtInst;
				emit onChangedCurrentInst(pCrtInst,pOldCrtInst);
				
			}	
			else
			{
			  emit onConnectEditInst();
			}
			emit onChangedDestoInst();
			emit onDisconnectEditDes();	
			
			
		}
//change inst to inst
		else if(flag2==1)
		{
            if(flag4==1)
			{
				m_pCrtInst = pCrtInst;
		
			emit onChangedCurrentInst(pCrtInst,pOldCrtInst);}
            //change uiitem to inst


		}


//change uiitem to des
		else if(flag6==1&&flag1==1)
		{
			if(pCrtItem==m_flatStructTemplateUiItem)
			{
				emit onChangedUitoTemplate();
			}
			else
			{
				emit onChangedUitoDes(pCrtDes->isInstantiation());
			}
		}
//change uiitem to inst
        /*else if(flag6==1&&flag2==1)
		{
			emit onChangedUitoInst();
        }*/
	}
}




//_________________________________________________________________________________________________
//modified by bini
void ProjStructureUiPart::onFlatStructItemActivated(QTreeWidgetItem* item, int /*column*/)
{
	if (isDesFlatViewItem(*item))
	{
		if(item->parent()->parent()==m_flatStructTemplateUiItem)
		{

			emit onEnterCurrentInst();
		}
		else
		{
			emit onEnterCurrentDes();
		}
	}
	
}

//_________________________________________________________________________________________________
//modified by bini
void ProjStructureUiPart::onFlatStructItemDeleted()
{
	QTreeWidgetItem* pCrtItem = m_fViewProjStructWidg->currentItem();
	if (pCrtItem && isDesFlatViewItem(*pCrtItem)&&(pCrtItem!= m_flatStructInstUiItem))
	{
		emit onCurrentDesDeleted();
	}
	else if(pCrtItem && isDesFlatViewItem(*pCrtItem)&&(pCrtItem== m_flatStructInstUiItem))
	{
		emit onCurrentInstantiationDelete();
	}
}

} //end of namespace DESpot
