/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc

	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering,
	Computing and Software Department,
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QTabWidget>

#include "Workspace.h"
#include "OutputWidget.h"

class QAction;
class QMenu;
class QToolBar;
class QResizeEvent;
class QButtonGroup;


namespace DESpot
{
	class Des;
	class ProjectEditor;
	class DesProject;
	class EventPoolForm;

	class ProjStructureUiPart;
	class ProjSummaryUiPart;
	class DesViewUiPart;
	class OutputUiPart;
	class ProgressWidget;

	class ProjectWorkspace: public Workspace
	{
		Q_OBJECT

		public:
			virtual ~ProjectWorkspace(void);

		//Protect constructor to deny creation. This is intended to be only a base class for concrete project workspace classes
		protected:
			ProjectWorkspace(ProjectEditor* pProjectEditor, DesProject* pProject);

		//Access to UI parts
		public:
			ProjStructureUiPart& projStructureUiPart();
			ProjSummaryUiPart&   projSummaryUiPart();
			DesViewUiPart& desViewUiPart();
			OutputUiPart& outputUiPart();

			bool useGraphEditor();

			virtual ProgressWidget* progressWidget() = 0;


		protected slots:
			virtual void onChangedCurrentDes(Des* pNewCrtDes, Des* pOldCrtDes);
			virtual void onChangedCurrentInst(Instantiation* pNewCrtInst, Instantiation* pOldCrtInst);
			//virtual void onChangedTemplateInstantiate(bool isInstantiation);
			virtual void onChangedDestoInst();
			virtual void onChangedInsttoDes(bool isInstantiation);
			virtual void onChangedInsttoTemplate();
			virtual void onChangedUiItem();
			virtual void onChangedUitoTemplate();
			virtual void onChangedUitoDes(bool isInstantiation);
			virtual void onChangedUitoInst();
			virtual void onConnectEditInst();
			virtual void onConnectEditDes();
			virtual void onDisconnectEditInst();
			virtual void onDisconnectEditDes();

		//Implementations Methods ____________________________
		protected:
			ProjectEditor* projectEditor();

			void setupConnections();
			void createActions();
			void setupMenu();
			void setupToolBar();
			void setupStatusBar();
			void setProjectEditorTitle(const QString& editorTypeDesc, const std::wstring& projName);

		//Actions_____________________________________________
		protected:
			// Project actions
			QAction* m_newFlatProjectAct;
			QAction* m_newHierProjectAct;
			QAction* m_openProjectAct;
			QAction* m_saveProjectAct;
			QAction* m_saveProjectAsAct;
			QAction* m_viewEventPoolAct;
			QAction* m_decentralizedEventEditorAct;
			QAction* m_addObserverAct;
			QAction* m_removeObserverAct;
			
			QAction* m_projectSetNameAct;
			QAction* m_printProjectAct;
			QAction* m_closeProjectAct;

			//DES actions
			QAction* m_addDesAct;
			QAction* m_removeDesAct;
			QAction* m_editDesAct;
//add by bini
			QAction* m_instantiateDesAct;
			QAction* m_deleteInstantiationAct;
			QAction* m_regenerateInstantiationAct;
			QAction* m_editInstAct;

			//add by XMA to choose editor
			QAction *m_tabularEditorAct;
			QAction *m_graphEditorAct;

			//Native Tools actions
			QAction* m_checkProjectIntegAct;
			QAction* m_checkProjectAct;
			QAction* m_cleanProjectAct;
			QAction* m_runMeetToolAct;
			QAction* m_runSyncToolAct;
			QAction* m_runNonblockToolAct;
			QAction* m_runCtrlToolAct;
			QAction* m_runCoObsToolAct;
			QAction* m_runMultiCtrlToolAct;
			QAction* m_runSynthesisToolAct;

            //Simulation
			QAction* m_runSimAct;
			//Counter example
			QAction* m_runCounterExampleAct;
			

			#ifdef __ENABLE_BDD__
				QAction* m_runBddMeetToolAct;
				QAction* m_runBddSyncToolAct;
				//removed by Adam. No longer in flat only hisc (moved to HierProjectWorkspace.h)
				//QAction* m_runBddNonblockToolAct;
				//QAction* m_runBddCtrlToolAct;
				QAction* m_runBddSynthesisToolAct;
			#endif

			// Added by David for distributed tools
			QAction* m_configDistAct;

			#ifdef __ENABLE_NEXT_VERSION__
				QAction* m_runSupconToolAct;
			#endif
			//Help actions
			QAction* m_openHelpFileAct;
			QAction* m_aboutDespotAct;

		//Menus_______________________________________________
		protected:
			QMenu* m_projectMenu;
			QMenu* m_newProjectMenu;
			QMenu* m_desMenu;
			QMenu* m_toolsMenu;

			#ifdef __ENABLE_BDD__
				QMenu* m_bddToolsMenu;
			#endif
			QMenu* m_distToolsMenu;

			QMenu* m_helpMenu;

		//Toolbars____________________________________________
		protected:
			QToolBar* m_projectToolBar;
			QToolBar* m_toolsToolBar;

		//UI Parts______________________________
		protected:
			ProjStructureUiPart* m_pProjStructUiPart;
			ProjSummaryUiPart* m_pSummaryUiPart;
			DesViewUiPart* m_pDesViewUiPart;
			OutputUiPart* m_pOutputUiPart;
	};

} //end of namespace DESpot
