/*************************************************************************
 * This file is part of Graphic des EDitor project    
 *
 * Project created in conformity with the requirements for the Degree of
 * Master of Engineering in Software Engineering, Computing and Software
 * Department, McMaster University 2004 - 2008
 *
 * Author:	Xiao Ma
 * Supervisor: Dr. Ryan Leduc
*************************************************************************/

/* 
 NAME
   SimConfigWizard.h - DES SIMulation Configuration wizard. 
 FUNCTION
 NOTES
 MODIFIED
   xma	    07/01/08 - CREATION 
*/

#ifndef SimConfigWizard_H
#define SimConfigWizard_H

#include <QWizard>
#include <QtWidgets>
#include "SimConfig.h"

class QCheckBox;
class QGroupBox;
class QLabel;
class QLineEdit;
class QRadioButton;


namespace DESpot
{

class DesProject;
class SimStateModel;
class ProjEventSetWidget;
class SimEventModel;
class SimTypePage;
class InitStateTuplePage;
class SimEventSetPage;
class OptionsPage;
class SimStopCondition;

class SimConfigWizard : public QWizard
{
    Q_OBJECT

public:
	SimConfigWizard(SimConfig *simConfig, QWidget *parent = 0);
	~SimConfigWizard(void);

    void accept();

private:
	SimConfig			*simConfig;
	DesProject			*desProject;
	DesHierProject		*hierProject;
	DesFlatProject		*flatProject;
	SimTypePage			*simTypePg;
	InitStateTuplePage	*initStateTuplePg;
    SimEventSetPage		*simEventSetPg;
    OptionsPage			*optionsPg;

};

class IntroductionPage : public QWizardPage
{
    Q_OBJECT

public:
    IntroductionPage(QWidget *parent = 0);

private:
    QLabel *label;
};

class SimTypePage : public QWizardPage
{
    Q_OBJECT

public:
    SimTypePage(SimConfig* simConfig, QWidget *parent = 0);
	SimConfig::SimMode simMode();
	SimConfig::EventSetMode eventSetMode();

private:
	QRadioButton* hierTypeRadioButton;
	QRadioButton* hierAsFlatTypeRadioButton;
	QRadioButton* flatTypeRadioButton;

	QRadioButton* seqModeRadioButton;
	QRadioButton* setModeRadioButton;

};

class InitStateTuplePage : public QWizardPage
{
    Q_OBJECT

public:
    InitStateTuplePage(SimConfig* simConfig, QWidget *parent = 0);
	SimCompState::StateTuple initStateTuple();

private slots:
	void stateChanged();

private:
	QTreeView* startStatesView;
	SimStateModel* stateModel;
	SimConfig* simConfig;
};

class SimEventSetPage : public QWizardPage
{
    Q_OBJECT

public:    
    SimEventSetPage(SimConfig* simConfig, QWidget *parent = 0);
	SimConfig::ProjectEventSet eventSet();

public slots:
	void onAddEvents();
	void onAddAllEvents();
	void onRemoveEvents();
	void onCustomizeEvents();

protected:
    void initializePage();

private:
	void updateSelEventTab(SimConfig::ProjectEventSet eventSet);

	//DesHierProject* project;
	DesProject* project;
	SimConfig* simConfig;
	SimEventModel* selectedEventModel;
	QTableView* selEventTab;
	QPushButton* addEvButton;
	QPushButton* addAllButton;
	QPushButton* removeEvButton;
	QPushButton* removeAllButton;
	QPushButton* customizeButton;


};

class OptionsPage : public QWizardPage
{
    Q_OBJECT

public:
    OptionsPage(QWidget *parent = 0);
	SimStopCondition stopCondition();

//protected:
//    void initializePage();

private:
    QLabel *label;

	QRadioButton* unlimitRadioButton ;
	QRadioButton* stepRadioButton ;
	QLineEdit* stepLineEdit;
	QRadioButton* markedStateRadioButton ;
	QRadioButton* initStateRadioButton ;

};

}
#endif
