/*************************************************************************
 * This file is part of Graphic des EDitor project    
 *
 * Project created in conformity with the requirements for the Degree of
 * Master of Engineering in Software Engineering, Computing and Software
 * Department, McMaster University 2004 - 2008
 *
 * Author:	Xiao Ma
 * Supervisor: Dr. Ryan Leduc
*************************************************************************/

/* 
 NAME
   SimEventChooser.h - DES SIMulation event set chooser. 
 FUNCTION
 NOTES
 MODIFIED
   xma	    04/01/08 - CREATION 
*/

#ifndef GEDDESTRANSEDITOR_H
#define GEDDESTRANSEDITOR_H

#include <QtWidgets>
#include <QDialog>
#include <QMap>
#include "SimConfig.h"

class QListWidget;
class QPushButton;

namespace DESpot
{

class DesHierProject;
class ProjEventSetWidget;
class SimEventModel;
class SimConfig;

class SimEventChooser : public QDialog
{
    Q_OBJECT

public:
	SimEventChooser(DesProject* project, 
					SimConfig::ProjectEventSet eventSet,
					SimConfig::EventSetMode eventMode,
					QWidget *parent = 0);
	~SimEventChooser();
    void done(int result);

	SimConfig::ProjectEventSet getSelectedEvents();

private slots:
	void onAddEvents();
	void onRemoveEvents();
	void onAddAllEvents();
	void onRemoveAllEvents();
	void onMoveUpEvents();
	void onMoveDownEvents();

private:
	void createAvailEventList();
	void createSelectedEventList(SimConfig::ProjectEventSet);
	void createLayout();
	//current selected row in selected list
	int selectedRow();
	bool eventSelectedAlready(const ProjectEvent* ev);

	DesProject* project;
	SimConfig::EventSetMode simEventMode;
	ProjEventSetWidget* availEventTree;
	SimEventModel* selectedEventModel;
	QTableView* selEventTab;
	QPushButton* addEvButton;
	QPushButton* addAllButton;
	QPushButton* removeEvButton;
	QPushButton* removeAllButton;
	QPushButton* customizeButton;
	QPushButton* upButton;
	QPushButton* downButton;
  
	QPushButton *okButton;
    QPushButton *cancelButton;
	bool modified;

};

}
#endif
