#ifndef SIMGEDVIEWER_H
#define SIMGEDVIEWER_H

#include <QtWidgets/QMainWindow>
#include "ui_SimGedViewer.h"
#include "SimGedViewerScene.h"

namespace DESpot
{
class Des;
class SimCompState;

class SimGedViewer : public QMainWindow, private Ui::SimGedViewerClass
{
    Q_OBJECT

public:
    SimGedViewer(Des* pDes, QWidget *parent = 0);
    ~SimGedViewer();

    QRect  suggestGeometry()
           {return m_pScene->suggestGeometry();  }
    void init() { m_pScene->init(); }
    void updateView(SimCompState* pCurState, bool isRunningMode = true) { if (isVisible()) { m_pScene->updateView(pCurState, isRunningMode); } }

public Q_SLOTS:
    virtual void setVisible(bool visible) { setVisible(visible, false); }
    virtual void setVisible(bool visible, bool supressSignals);

signals:
	void visibilityChanged(bool visibility);

private:
    SimGedViewerScene* m_pScene;
};

} // end of namespace

#endif // SIMGEDVIEWER_H
