#include <QtWidgets>

#include "SimStateDelegate.h"
#include "SimStateNode.h"
#include "SimStateModel.h"

namespace DESpot
{

SimStateDelegate::SimStateDelegate(int stateColumn, QObject *parent)
    : QItemDelegate(parent)
{
    this->stateColumn = stateColumn;
}

void SimStateDelegate::paint(QPainter *painter,
                          const QStyleOptionViewItem &option,
                          const QModelIndex &index) const
{
	/*
    if (index.column() == stateColumn) {
        int secs = index.model()->data(index, Qt::DisplayRole).toInt();
        QString text = QString("%1:%2")
                       .arg(secs / 60, 2, 10, QChar('0'))
                       .arg(secs % 60, 2, 10, QChar('0'));

        QStyleOptionViewItem myOption = option;
        myOption.displayAlignment = Qt::AlignRight | Qt::AlignVCenter;

        drawDisplay(painter, myOption, myOption.rect, text);
        drawFocus(painter, myOption, myOption.rect);
    } else{
        QItemDelegate::paint(painter, option, index);
    }
	*/
	QItemDelegate::paint(painter, option, index);
}

QWidget *SimStateDelegate::createEditor(QWidget *parent,
        const QStyleOptionViewItem &option,
        const QModelIndex &index) const
{
    if (index.column() == stateColumn) {
        QComboBox *stateComboBox = new QComboBox(parent);
		stateComboBox->setEditable(false);
		QStringList stateList;
		//To generate state list here
		const SimStateModel* stateModel = qobject_cast<const SimStateModel*>(index.model());
		Node *node = stateModel->nodeFromIndex(index);
		const Des *des = node->des;
		Des::StateIteratorPtr stateIt = des->createStateIterator();
		for(stateIt->first(); stateIt->isDone() == false; stateIt->next())
		{
			const DesState& state = stateIt->currentItem();
			stateList<<QString::fromStdWString(state.getName());	
		}
		//stateList<<"s0"<<"s1"<<"s2"<<"s3"<<"s4";
		stateComboBox->insertItems(0,stateList);
        connect(stateComboBox, SIGNAL(activated()),
                this, SLOT(commitAndCloseEditor()));
        return stateComboBox;
    } else {
        return QItemDelegate::createEditor(parent, option, index);
    }
}

void SimStateDelegate::setEditorData(QWidget *editor,
                                  const QModelIndex &index) const
{
    /*
	if (index.column() == stateColumn) {
        QString state = index.model()->data(index, Qt::DisplayRole);
        QComboBox *stateComboBox = qobject_cast<QComboBox *>(editor);
        statList->setTime(QTime(0, secs / 60, secs % 60));
    } else {
        QItemDelegate::setEditorData(editor, index);
    }
	*/
	QItemDelegate::setEditorData(editor, index);
}


void SimStateDelegate::setModelData(QWidget *editor,
                                 QAbstractItemModel *model,
                                 const QModelIndex &index) const
{
    if (index.column() == stateColumn) {
        QComboBox *stateComboBox = qobject_cast<QComboBox *>(editor);
		QString myText = stateComboBox->itemText(stateComboBox->currentIndex());
        model->setData(index, myText);
    } else {
        QItemDelegate::setModelData(editor, model, index);
    }

//	QItemDelegate::setModelData(editor, model, index);
}

void SimStateDelegate::commitAndCloseEditor()
{
    QComboBox *editor = qobject_cast<QComboBox *>(sender());
    emit commitData(editor);
    emit closeEditor(editor);
}


}
