/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QWidget>
#include <QCursor>

namespace DESpot
{
	class WaitCursor
	{
		public:
			WaitCursor(QWidget* waitingWidget) : m_waitingWidget(waitingWidget)
			{
				m_originalCursor = waitingWidget->cursor();
				m_waitingWidget->setCursor(Qt::WaitCursor);
			}

			~WaitCursor(void)
			{
				m_waitingWidget->setCursor(m_originalCursor);
			}

		private:
			QCursor m_originalCursor;
			QWidget* m_waitingWidget;
	};
}
