/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#pragma once

#include <QDialog>

#include "ui_AddLowLevelSubsysDlg.h"
#include "DesHierProject.h"

namespace DESpot
{
	class AddLowLevelSubsysDlg: public QDialog, private Ui::AddLowLevelSubsysDlgUI
	{
		public:
			AddLowLevelSubsysDlg(const DesHierProject& project, QWidget* parent = null);
			~AddLowLevelSubsysDlg(void);
	
		public:
			std::wstring getSubsysName() const;

			std::wstring getInterfName() const;
			void setInterfName(const std::wstring& interfName);
			bool isNewInterface() const;

		private:
			void setupInterfWidget();

		//Overridables
		protected:
			virtual void accept();
			virtual void reject();

		private:
			const DesHierProject& m_project;
			std::wstring m_subsysName;
			std::wstring m_interfName;
			bool m_newInterface;
	};

} //end of namespace DESpot
