/*************************************************************************
  FILE:  BddHiscDES.h
  DESCR: Header file of DES.cpp (Process DES file)
  AUTH:  Raoguang Song
  Supervisor: Dr. Ryan Leduc
  DATE:  (C) Jan, 2006
*************************************************************************/
#ifndef _BddHiscDES_H_
#define _BddHiscDES_H_

#include <string>
#include <map>
#include <list>
#include "BddHiscType.h"
#include <fstream>

#include "Des.h"

using namespace std;

namespace BDDHISC
{

class CSub;

class CDES
{
public: //Constructor and Destructor
    CDES(CSub *vpSub, const string &vsDESFile, const DESTYPE vDESType);
    virtual ~CDES();
    
public:
    int LoadDES(DESpot::Des& theDes, bool isHigh);
    int PrintDES(ofstream & fout);
    
public:
    string GetDESName() const {return m_sDESName;};
    int * GetEventsArr() {return m_piEventsArr;};
    int GetNumofEvents() const {return m_DESEventsMap.size();};
    int GetNumofMarkingStates() const {return m_MarkingList.size();};
    MARKINGLIST & GetMarkingList() {return m_MarkingList;};
    int GetNumofStates() const { return m_iNumofStates;};
    int GetInitState() const {return m_iInitState;};
    map<int, int> *GetTrans() const {return m_pTransArr;};
    DESTYPE GetDESType() const {return m_DESType;};
    CSub*  GetSub() {return m_pSub;};
    string GetStateName(int iState) {
#ifdef _WIN32
      return m_InvStatesMap[iState + 1];
#else
      return m_InvStatesMap[iState];
#endif
};
    
private: //data memeber
    string m_sDESFile;   //DES file name with path
    string m_sDESName;   //DES name without path and file extension
    DESTYPE m_DESType;   //DES type 
    
    int m_iNumofStates; //Number of States
    int m_iInitState;  //Initial state
    
    MARKINGLIST m_MarkingList; //Link list containing all marking states
    
    STATES m_StatesMap; //A STL Map for states (state name (key), state index)
    INVSTATES m_InvStatesMap; //A STL Map for states (state index (key),
                              //state name)(for printing)

    EVENTS m_DESEventsMap;  //A STL Map for events (event name (key), 
                            //local event index). Used only for current DES
                            //(speed reason)
    INVEVENTS m_InvDESEventsMap; //A STL Map for events (localindex (key), 
                                //event name). Used only for current DES
                                //(for printing)
    EVENTS m_UnusedEvents; //A STL Map for blocked events(name: key, index)

    int *m_piEventsArr;  //Save all the event indices ascendingly.
                         //used for find shared events between two DESes.
    
    TRANS *m_pTransArr; //Transiton Map array, indexed by event indices.
                        //TRANSMAP: first int: source state index
                        //          second int: target state index
    CSub *m_pSub; //which subsystem this DES belongs to
private: //internal function members
    int AddEvent(const string & vsEventName, 
                 const char cEventSub, 
                 const char cControllable);
    int AddTrans(const string & vsLine, 
                 const string & vsExitState, 
                 const int viExitState);
};


} //end of namespace BDDHISC

#endif //_BddHiscDES_H_
