/*	Author:		Magdin Stoica
	Supervisor: Dr. Ryan Leduc
	
	Project created in conformity with the requirements for the Degree of Master of Engineering in Software Engineering, 
	Computing and Software Department, 
	McMaster University
	2003 - 2007
*/

#include "DesStateSetTableWidget.h"
#include "Des.h"

namespace DESpot
{

DesStateSetTableWidget::DesStateSetTableWidget(QWidget* parent): DesDataTableWidget(parent)
{
}

//_________________________________________________________________________________________________

DesStateSetTableWidget::~DesStateSetTableWidget(void)
{
}

//_________________________________________________________________________________________________

void DesStateSetTableWidget::loadData(Des* des, bool /*highLevelDes*/)
{
	//first clear all states
	setupWidget(m_tableColCount);

	//calculate and set the number of rows in the table necessary to load all states
	setRowCount(calculateRowCount(des->getStateCount(), m_tableColCount));

	//load the states into the table
	int crtCol = 0;
	int crtRow = 0;
	Des::StateIteratorPtr stateIt = des->createStateIterator();
	for(stateIt->first(); stateIt->notDone(); stateIt->next())
	{
		const DesState& crtState = stateIt->currentItem();
		 
		QString itemText = QString("%1 (%2)").arg(QString::fromStdWString(crtState.getName()), 
												   QString::fromStdWString(crtState.getAlias()));

		QString itemTooltip = QString("%1\n\nInitial State:\t%2\nMarked State:\t%3\nReachable:\t%4").arg(
										itemText,
										crtState.isInit() ? cYes : cNo,
										crtState.isMarked() ? cYes : cNo,
										crtState.isReachKnown() ? (crtState.isReachable() ? cYes : cNo) : cUnknown);
		
		QTableWidgetItem* crtStateItem = new QTableWidgetItem();
		crtStateItem->setText(itemText);
		crtStateItem->setToolTip(itemTooltip);
		crtStateItem->setFlags(crtStateItem->flags() & ~Qt::ItemIsEditable);
		
		//make the text bold if the state is marked
		if (crtState.isMarked())
		{
			QFont font = crtStateItem->font();
			font.setBold(true);
			crtStateItem->setFont(font);
		}
		
		//make the text blue if the current state is the initial state
		if (crtState.isInit())
		{
			crtStateItem->setTextColor(Qt::blue);
		}
		
		//make the text read if the state is unreachable
		if (crtState.isReachKnown() && crtState.isReachable() == false)
		{
			crtStateItem->setTextColor(Qt::red);
		}
		
		//add the item to the table
		setItem(crtRow, crtCol, crtStateItem);

		//increase the row and the column index
		calculateNextRowAndCol(crtRow, crtCol);
	}

	//now that all states have been added, auto-resize all rows
	autoResizeTableRows();
}

} //end of namespace DESpot
